<?php
defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('format_bytes')) {
    function format_bytes($bytes, $precision = 2) {
        $units = array('B', 'KB', 'MB', 'GB', 'TB');
        
        for ($i = 0; $bytes > 1024 && $i < count($units) - 1; $i++) {
            $bytes /= 1024;
        }
        
        return round($bytes, $precision) . ' ' . $units[$i];
    }
}

if (!function_exists('get_backup_files')) {
    function get_backup_files() {
        $backup_dir = 'dbbackup/';
        $files = array();
        
        if(is_dir($backup_dir)){
            $file_list = scandir($backup_dir);
            foreach($file_list as $file){
                if($file != '.' && $file != '..' && 
                   (pathinfo($file, PATHINFO_EXTENSION) == 'zip' || 
                    pathinfo($file, PATHINFO_EXTENSION) == 'sql')){
                    $filepath = $backup_dir . $file;
                    if(file_exists($filepath)){
                        $files[] = array(
                            'name' => $file,
                            'size' => format_bytes(filesize($filepath)),
                            'date' => date('Y-m-d H:i:s', filemtime($filepath)),
                            'type' => pathinfo($file, PATHINFO_EXTENSION),
                            'is_uploaded' => strpos($file, 'uploaded_') === 0
                        );
                    }
                }
            }
        }
        
        // Sort by date (newest first)
        usort($files, function($a, $b) {
            return strtotime($b['date']) - strtotime($a['date']);
        });
        
        return $files;
    }
} 