<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Account Statement - <?php echo $account->account_name; ?></title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="stylesheet" href="<?php echo $base_url; ?>theme/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo $base_url; ?>theme/css/font-awesome.min.css">
    <link rel="stylesheet" href="<?php echo $base_url; ?>theme/css/AdminLTE.min.css">
    <style>
        @media print {
            .no-print { display: none !important; }
            .print-only { display: block !important; }
            body { font-size: 12px; margin: 0; padding: 0; }
            .statement-container { margin: 0; padding: 15px; max-width: 100%; }
            .page-break { page-break-after: always; }
        }
        .print-only { display: none; }
        
        body { 
            font-family: Arial, sans-serif; 
            font-size: 13px; 
            line-height: 1.4;
            background: #f5f5f5;
            margin: 0;
            padding: 20px;
        }
        
        .statement-container { 
            max-width: 800px; 
            margin: 0 auto; 
            background: white;
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
            border-radius: 10px;
            overflow: hidden;
        }
        
        /* Header */
        .statement-header {
            background: linear-gradient(135deg, #1e3c72 0%, #2a5298 100%);
            color: white;
            padding: 25px;
            text-align: center;
        }
        
        .company-name {
            font-size: 22px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .statement-title {
            font-size: 16px;
            opacity: 0.9;
            margin-bottom: 15px;
        }
        
        .statement-period {
            background: rgba(255,255,255,0.2);
            padding: 8px 15px;
            border-radius: 20px;
            font-size: 12px;
            display: inline-block;
        }
        
        /* Account Info */
        .account-info {
            background: #f8f9fa;
            padding: 20px;
            border-bottom: 2px solid #1e3c72;
        }
        
        .account-details {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .account-main {
            flex: 1;
        }
        
        .account-name {
            font-size: 18px;
            font-weight: bold;
            color: #1e3c72;
            margin-bottom: 5px;
        }
        
        .account-code {
            font-size: 14px;
            color: #666;
            margin-bottom: 5px;
        }
        
        .account-currency {
            font-size: 12px;
            color: #888;
        }
        
        .account-balance {
            text-align: right;
        }
        
        .balance-label {
            font-size: 12px;
            color: #666;
            margin-bottom: 5px;
        }
        
        .balance-amount {
            font-size: 24px;
            font-weight: bold;
            color: #1e3c72;
        }
        
        /* Statement Period */
        .period-info {
            background: #e8f4fd;
            padding: 15px;
            margin: 20px;
            border-radius: 8px;
            text-align: center;
        }
        
        .period-title {
            font-size: 14px;
            font-weight: bold;
            color: #1e3c72;
            margin-bottom: 5px;
        }
        
        .period-dates {
            font-size: 13px;
            color: #666;
        }
        
        /* Transactions Table */
        .transactions-section {
            padding: 20px;
        }
        
        .section-title {
            font-size: 16px;
            font-weight: bold;
            color: #1e3c72;
            margin-bottom: 15px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .transactions-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        .transactions-table th {
            background: #1e3c72;
            color: white;
            padding: 12px 8px;
            text-align: left;
            font-size: 12px;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .transactions-table td {
            padding: 10px 8px;
            border-bottom: 1px solid #ddd;
            font-size: 12px;
        }
        
        .transactions-table tr:nth-child(even) {
            background: #f9f9f9;
        }
        
        .transactions-table tr:hover {
            background: #f0f8ff;
        }
        
        .date-col {
            width: 12%;
        }
        
        .description-col {
            width: 35%;
        }
        
        .debit-col {
            width: 15%;
            text-align: right;
        }
        
        .credit-col {
            width: 15%;
            text-align: right;
        }
        
        .balance-col {
            width: 15%;
            text-align: right;
        }
        
        .note-col {
            width: 8%;
        }
        
        .debit-amount {
            color: #dc3545;
            font-weight: bold;
        }
        
        .credit-amount {
            color: #28a745;
            font-weight: bold;
        }
        
        .balance-positive {
            color: #28a745;
            font-weight: bold;
        }
        
        .balance-negative {
            color: #dc3545;
            font-weight: bold;
        }
        
        /* Summary */
        .summary-section {
            background: #f8f9fa;
            padding: 20px;
            border-top: 2px solid #1e3c72;
        }
        
        .summary-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            font-size: 13px;
        }
        
        .summary-label {
            font-weight: bold;
            color: #666;
        }
        
        .summary-value {
            font-weight: bold;
            color: #333;
        }
        
        .total-row {
            border-top: 2px solid #1e3c72;
            padding-top: 10px;
            margin-top: 10px;
            font-size: 14px;
        }
        
        /* Footer */
        .statement-footer {
            background: #f8f9fa;
            padding: 20px;
            border-top: 1px solid #e0e0e0;
            font-size: 11px;
            color: #666;
        }
        
        .footer-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        
        .company-info {
            flex: 1;
        }
        
        .signature-section {
            text-align: right;
        }
        
        .signature-line {
            border-bottom: 1px solid #333;
            width: 150px;
            margin: 5px 0;
        }
        
        .terms {
            font-size: 10px;
            color: #666;
            text-align: center;
            margin-top: 15px;
        }
        
        /* Action Buttons */
        .action-buttons {
            text-align: center;
            padding: 20px;
            background: #f8f9fa;
            border-top: 1px solid #e0e0e0;
        }
        
        .btn-group {
            display: inline-flex;
            gap: 10px;
            flex-wrap: wrap;
            justify-content: center;
        }
        
        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 6px;
            font-size: 12px;
            font-weight: bold;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        
        .btn-primary {
            background: #007bff;
            color: white;
        }
        
        .btn-primary:hover {
            background: #0056b3;
            transform: translateY(-2px);
        }
        
        .btn-success {
            background: #28a745;
            color: white;
        }
        
        .btn-success:hover {
            background: #1e7e34;
            transform: translateY(-2px);
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn-secondary:hover {
            background: #545b62;
            transform: translateY(-2px);
        }
        
        /* Print Optimizations */
        @media print {
            body {
                background: white;
                padding: 0;
            }
            .statement-container {
                box-shadow: none;
                border-radius: 0;
                margin: 0;
                max-width: 100%;
            }
            .statement-header {
                background: #1e3c72 !important;
                -webkit-print-color-adjust: exact;
            }
            .transactions-table th {
                background: #1e3c72 !important;
                -webkit-print-color-adjust: exact;
            }
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .account-details {
                flex-direction: column;
                text-align: center;
            }
            .account-balance {
                text-align: center;
                margin-top: 15px;
            }
            .footer-row {
                flex-direction: column;
            }
            .signature-section {
                text-align: left;
                margin-top: 15px;
            }
            .btn-group {
                flex-direction: column;
                align-items: center;
            }
        }
    </style>
</head>
<body>
    <div class="statement-container">
        <!-- Header -->
        <div class="statement-header">
            <div class="company-name"><?php echo $store_details->store_name; ?></div>
            <div class="statement-title">ACCOUNT STATEMENT</div>
            <div class="statement-period">
                <?php echo date('M d, Y', strtotime($from_date)); ?> - <?php echo date('M d, Y', strtotime($to_date)); ?>
            </div>
        </div>
        
        <!-- Account Information -->
        <div class="account-info">
            <div class="account-details">
                <div class="account-main">
                    <div class="account-name"><?php echo $account->account_name; ?></div>
                    <div class="account-code">Account Code: <?php echo $account->account_code; ?></div>
                    <div class="account-currency">Currency: <?php echo $account->currency_name . ' (' . $account->currency_code . ')'; ?></div>
                </div>
                <div class="account-balance">
                    <div class="balance-label">Current Balance</div>
                    <div class="balance-amount"><?php echo format_currency_amount($account->balance, $account->currency_id); ?></div>
                </div>
            </div>
        </div>
        
        <!-- Statement Period -->
        <div class="period-info">
            <div class="period-title">Statement Period</div>
            <div class="period-dates">
                From: <?php echo date('F d, Y', strtotime($from_date)); ?> | 
                To: <?php echo date('F d, Y', strtotime($to_date)); ?>
            </div>
        </div>
        
        <!-- Transactions -->
        <div class="transactions-section">
            <div class="section-title">Transaction History</div>
            
            <?php if (!empty($transactions)): ?>
                <table class="transactions-table">
                    <thead>
                        <tr>
                            <th class="date-col">Date</th>
                            <th class="description-col">Description</th>
                            <th class="debit-col">Debit</th>
                            <th class="credit-col">Credit</th>
                            <th class="balance-col">Balance</th>
                            <th class="note-col">Note</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $running_balance = $opening_balance;
                        foreach ($transactions as $transaction): 
                            $is_debit = ($account->id == $transaction->debit_account_id);
                            $amount = $is_debit ? $transaction->debit_amt : $transaction->credit_amt;
                            
                            // For expense transactions, use the corrected amount if available
                            if ($transaction->transaction_type == 'EXPENSE PAYMENT' && $transaction->ref_expense_id && $is_debit) {
                                $expense_info = $this->db->select('expense_amt, expense_currency_id')
                                    ->where('id', $transaction->ref_expense_id)
                                    ->get('db_expense')->row();
                                
                                if ($expense_info && $expense_info->expense_currency_id == $account->currency_id) {
                                    $amount = $expense_info->expense_amt;
                                }
                            }
                            
                            $running_balance += $is_debit ? -$amount : $amount;
                        ?>
                        <tr>
                            <td><?php echo date('M d, Y', strtotime($transaction->transaction_date)); ?></td>
                            <td>
                                <strong><?php echo ucwords(strtolower($transaction->transaction_type)); ?></strong>
                                <?php if (!empty($transaction->note)): ?>
                                    <br><small><?php echo $transaction->note; ?></small>
                                <?php endif; ?>
                                <?php if (isset($transaction->exchange_rate) && $transaction->exchange_rate != 1.0): ?>
                                    <br><small class="text-info">
                                        <i class="fa fa-exchange"></i> 
                                        Rate: <?php echo number_format($transaction->exchange_rate, 4); ?>
                                        <?php if (isset($transaction->base_currency_credit_amt) && $transaction->base_currency_credit_amt > 0): ?>
                                            | Base: <?php echo number_format($transaction->base_currency_credit_amt, 2); ?>
                                        <?php endif; ?>
                                    </small>
                                <?php endif; ?>
                            </td>
                            <td class="debit-col">
                                <?php if ($is_debit): ?>
                                    <span class="debit-amount"><?php 
                                        // Use the same logic as account book for expense transactions
                                        $display_amount = $amount;
                                        
                                        // For expense transactions, check if we need to use original amount
                                        if ($transaction->transaction_type == 'EXPENSE PAYMENT' && $transaction->ref_expense_id) {
                                            $expense_info = $this->db->select('expense_amt, expense_currency_id')
                                                ->where('id', $transaction->ref_expense_id)
                                                ->get('db_expense')->row();
                                            
                                            if ($expense_info && $expense_info->expense_currency_id == $account->currency_id) {
                                                $display_amount = $expense_info->expense_amt;
                                            }
                                        }
                                        
                                        // Display only account currency for print
                                        echo format_currency_amount($display_amount, $account->currency_id);
                                    ?></span>
                                <?php else: ?>
                                    <span>-</span>
                                <?php endif; ?>
                            </td>
                            <td class="credit-col">
                                <?php if (!$is_debit): ?>
                                    <span class="credit-amount"><?php 
                                        $display_amount = $amount;
                                        
                                        // Display only account currency for print
                                        echo format_currency_amount($display_amount, $account->currency_id);
                                    ?></span>
                                <?php else: ?>
                                    <span>-</span>
                                <?php endif; ?>
                            </td>
                            <td class="balance-col">
                                <span class="<?php echo $running_balance >= 0 ? 'balance-positive' : 'balance-negative'; ?>">
                                    <?php 
                                        // Display only account currency for print
                                        echo format_currency_amount($running_balance, $account->currency_id);
                                    ?>
                                </span>
                            </td>
                            <td class="note-col">
                                <?php if (!empty($transaction->created_by)): ?>
                                    <small><?php echo $transaction->created_by; ?></small>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <div class="text-center" style="padding: 40px; color: #666;">
                    <i class="fa fa-info-circle" style="font-size: 24px; margin-bottom: 10px;"></i><br>
                    No transactions found for the selected period.
                </div>
            <?php endif; ?>
        </div>
        
        <!-- Summary -->
        <div class="summary-section">
            <div class="summary-row">
                <span class="summary-label">Opening Balance:</span>
                <span class="summary-value"><?php echo format_currency_amount($opening_balance, $account->currency_id); ?></span>
            </div>
            <div class="summary-row">
                <span class="summary-label">Closing Balance:</span>
                <span class="summary-value"><?php echo format_currency_amount($account->balance, $account->currency_id); ?></span>
            </div>
            <div class="summary-row total-row">
                <span class="summary-label">Total Transactions:</span>
                <span class="summary-value"><?php echo count($transactions); ?></span>
            </div>
        </div>
        
        <!-- Footer -->
        <div class="statement-footer">
            <div class="footer-row">
                <div class="company-info">
                    <strong><?php echo $store_details->store_name; ?></strong><br>
                    <?php if (!empty($store_details->address)): ?>
                        <?php echo $store_details->address; ?><br>
                    <?php endif; ?>
                    <?php if (!empty($store_details->phone)): ?>
                        Phone: <?php echo $store_details->phone; ?><br>
                    <?php endif; ?>
                    <?php if (!empty($store_details->email)): ?>
                        Email: <?php echo $store_details->email; ?>
                    <?php endif; ?>
                </div>
                <div class="signature-section">
                    <div>Authorized Signature:</div>
                    <div class="signature-line"></div>
                    <div>Date: <?php echo date('M d, Y'); ?></div>
                </div>
            </div>
            
            <div class="terms">
                Generated: <?php echo date('M d, Y h:i A'); ?> | This is a computer-generated statement.
            </div>
        </div>
        
        <!-- Action Buttons -->
        <div class="action-buttons no-print">
            <div class="btn-group">
                <button onclick="printStatement()" class="btn btn-primary">
                    <i class="fa fa-print"></i> Print Statement
                </button>
                <button onclick="downloadPDF()" class="btn btn-success">
                    <i class="fa fa-file-pdf-o"></i> Download PDF
                </button>
                <a href="<?php echo $base_url; ?>accounts/book/<?php echo $account->id; ?>" class="btn btn-secondary">
                    <i class="fa fa-arrow-left"></i> Back to Account Book
                </a>
            </div>
        </div>
    </div>

    <script>
        function printStatement() {
            // Set document title with date for PDF
            const originalTitle = document.title;
            const accountName = '<?php echo $account->account_name; ?>';
            const fromDate = '<?php echo date('Y-m-d', strtotime($from_date)); ?>';
            const toDate = '<?php echo date('Y-m-d', strtotime($to_date)); ?>';
            document.title = `Account_Statement_${accountName.replace(/[^a-zA-Z0-9]/g, '_')}_${fromDate}_to_${toDate}`;
            
            window.print();
            
            // Restore original title
            document.title = originalTitle;
        }
        
        function downloadPDF() {
            printStatement();
        }
    </script>
</body>
</html>
