<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Expense Receipt</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f5f5f5;
        }
        
        .receipt-container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            border-radius: 8px;
            overflow: hidden;
        }
        
        .receipt-header {
            background: #ffffff;
            color: #000000;
            padding: 25px;
            text-align: center;
            border-bottom: 4px solid #000000;
        }
        
        .company-header {
            font-size: 20px;
            font-weight: 900;
            margin-bottom: 15px;
            color: #000000;
            line-height: 1.3;
        }
        
        .company-details {
            font-size: 14px;
            color: #333;
            margin-bottom: 20px;
            line-height: 1.4;
        }
        
        .receipt-title {
            font-size: 28px;
            font-weight: 900;
            margin: 20px 0;
            color: #000000;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .receipt-number {
            background: #f0f0f0;
            padding: 12px 20px;
            border-radius: 6px;
            display: inline-block;
            font-weight: 900;
            color: #000000;
            border: 3px solid #000000;
            font-size: 16px;
        }
        
        .receipt-body {
            padding: 30px;
        }
        
        .expense-details {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
            margin-bottom: 30px;
        }
        
        .detail-section h3 {
            margin: 0 0 15px 0;
            color: #333;
            font-size: 16px;
            border-bottom: 2px solid #007bff;
            padding-bottom: 5px;
        }
        
        .detail-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
            padding: 8px 0;
            border-bottom: 1px solid #eee;
        }
        
        .detail-label {
            font-weight: bold;
            color: #555;
        }
        
        .detail-value {
            color: #333;
        }
        
        .amount-section {
            background: #f8f9fa;
            padding: 25px;
            border-radius: 10px;
            text-align: center;
            margin: 25px 0;
            border: 3px solid #007bff;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .amount-label {
            font-size: 16px;
            color: #666;
            margin-bottom: 15px;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .amount-value {
            font-size: 36px;
            font-weight: 900;
            color: #dc3545;
            text-shadow: 1px 1px 2px rgba(0,0,0,0.1);
        }
        
        .notes-section {
            margin: 20px 0;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 5px;
            border-left: 4px solid #007bff;
        }
        
        .notes-section h4 {
            margin: 0 0 10px 0;
            color: #333;
        }
        
        .notes-content {
            color: #666;
            line-height: 1.5;
        }
        
        .footer {
            text-align: center;
            padding: 20px;
            background: #f8f9fa;
            color: #666;
            font-size: 12px;
        }
        
        .action-buttons {
            text-align: center;
            padding: 20px;
            background: #f8f9fa;
        }
        
        .btn {
            padding: 10px 20px;
            margin: 0 10px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
            text-decoration: none;
            display: inline-block;
        }
        
        .btn-primary {
            background: #007bff;
            color: white;
        }
        
        .btn-success {
            background: #28a745;
            color: white;
        }
        
        .btn:hover {
            opacity: 0.8;
        }
        
        /* Print Styles */
        @media print {
            body {
                background: white;
                padding: 0;
                margin: 0;
            }
            
            .receipt-container {
                box-shadow: none;
                border-radius: 0;
                max-width: none;
                margin: 0;
            }
            
            .action-buttons {
                display: none;
            }
            
            .receipt-header {
                background: #ffffff !important;
                color: #000000 !important;
                border-bottom: 4px solid #000000 !important;
                padding: 20px !important;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .company-header {
                color: #000000 !important;
                font-weight: 900 !important;
                font-size: 22px !important;
                margin-bottom: 15px !important;
            }
            
            .company-details {
                color: #000000 !important;
                font-size: 14px !important;
                margin-bottom: 20px !important;
            }
            
            .receipt-title {
                color: #000000 !important;
                font-weight: 900 !important;
                font-size: 32px !important;
                margin: 20px 0 !important;
                text-transform: uppercase !important;
            }
            
            .receipt-number {
                background: #f0f0f0 !important;
                color: #000000 !important;
                font-weight: 900 !important;
                border: 3px solid #000000 !important;
                padding: 12px 20px !important;
                font-size: 18px !important;
            }
            
            .receipt-body {
                padding: 25px !important;
            }
            
            .expense-details {
                grid-template-columns: 1fr 1fr;
                gap: 25px;
            }
            
            .detail-section h3 {
                color: #000000 !important;
                font-weight: 900 !important;
                font-size: 16px !important;
                border-bottom: 2px solid #000000 !important;
            }
            
            .detail-row {
                border-bottom: 1px solid #ccc !important;
            }
            
            .detail-label {
                color: #000000 !important;
                font-weight: bold !important;
            }
            
            .detail-value {
                color: #000000 !important;
            }
            
            .amount-section {
                border: 3px solid #000000 !important;
                background: #f8f9fa !important;
            }
            
            .amount-value {
                color: #dc3545 !important;
                font-size: 32px !important;
                font-weight: 900 !important;
            }
            
            .notes-section {
                border-left: 4px solid #000000 !important;
                background: #f8f9fa !important;
            }
            
            .notes-section h4 {
                color: #000000 !important;
                font-weight: 900 !important;
            }
            
            .notes-content {
                color: #000000 !important;
            }
            
            .footer {
                background: #f8f9fa !important;
                color: #000000 !important;
            }
        }
        
        /* 80mm Receipt Styles */
        @media print and (max-width: 80mm) {
            body {
                padding: 5px;
                margin: 0;
            }
            
            .receipt-container {
                max-width: 80mm;
                width: 80mm;
                margin: 0;
            }
            
            .receipt-header {
                padding: 15px 10px !important;
                border-bottom: 3px solid #000000 !important;
            }
            
            .company-header {
                font-size: 16px !important;
                font-weight: 900 !important;
                color: #000000 !important;
                margin-bottom: 10px !important;
            }
            
            .company-details {
                font-size: 11px !important;
                color: #000000 !important;
                margin-bottom: 15px !important;
                line-height: 1.3 !important;
            }
            
            .receipt-title {
                font-size: 20px !important;
                font-weight: 900 !important;
                color: #000000 !important;
                margin: 15px 0 !important;
                text-transform: uppercase !important;
            }
            
            .receipt-number {
                font-size: 14px !important;
                padding: 8px 12px !important;
                border: 2px solid #000000 !important;
                background: #f0f0f0 !important;
                color: #000000 !important;
                font-weight: 900 !important;
            }
            
            .receipt-body {
                padding: 15px 10px !important;
            }
            
            .expense-details {
                grid-template-columns: 1fr;
                gap: 15px;
            }
            
            .detail-section h3 {
                font-size: 14px !important;
                font-weight: 900 !important;
                color: #000000 !important;
                border-bottom: 2px solid #000000 !important;
                margin-bottom: 10px !important;
            }
            
            .detail-row {
                font-size: 11px !important;
                padding: 6px 0 !important;
                border-bottom: 1px solid #ccc !important;
            }
            
            .detail-label {
                color: #000000 !important;
                font-weight: bold !important;
            }
            
            .detail-value {
                color: #000000 !important;
            }
            
            .amount-section {
                padding: 15px 10px !important;
                border: 2px solid #000000 !important;
                background: #f8f9fa !important;
            }
            
            .amount-label {
                font-size: 12px !important;
                color: #000000 !important;
            }
            
            .amount-value {
                font-size: 22px !important;
                font-weight: 900 !important;
                color: #dc3545 !important;
            }
            
            .notes-section {
                padding: 10px !important;
                border-left: 3px solid #000000 !important;
                background: #f8f9fa !important;
            }
            
            .notes-section h4 {
                font-size: 12px !important;
                font-weight: 900 !important;
                color: #000000 !important;
                margin-bottom: 8px !important;
            }
            
            .notes-content {
                font-size: 11px !important;
                color: #000000 !important;
                line-height: 1.3 !important;
            }
            
            .footer {
                padding: 10px !important;
                font-size: 10px !important;
                background: #f8f9fa !important;
                color: #000000 !important;
            }
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <div class="receipt-header">
            <div class="company-header">
                <?php echo isset($store_details->store_name) ? $store_details->store_name : (isset($store_details->store) ? $store_details->store : ''); ?>
            </div>
            <div class="company-details">
                <?php 
                    $addr = isset($store_details->store_address) ? $store_details->store_address : (isset($store_details->address) ? $store_details->address : '');
                    $phone = isset($store_details->store_contact) ? $store_details->store_contact : (isset($store_details->phone) ? $store_details->phone : '');
                    $email = isset($store_details->store_email) ? $store_details->store_email : (isset($store_details->email) ? $store_details->email : '');
                    $website = isset($store_details->store_website) ? $store_details->store_website : (isset($store_details->website) ? $store_details->website : '');
                ?>
                <?php if(!empty($addr)): ?>
                    <?php echo $addr; ?><br>
                <?php endif; ?>
                <?php if(!empty($phone) || !empty($email)): ?>
                    <?php if(!empty($phone)): ?><strong>Tel:</strong> <?php echo $phone; ?><?php endif; ?>
                    <?php if(!empty($phone) && !empty($email)): ?> | <?php endif; ?>
                    <?php if(!empty($email)): ?><strong>Email:</strong> <?php echo $email; ?><?php endif; ?>
                    <br>
                <?php endif; ?>
                <?php if(!empty($website)): ?>
                    <strong>Website:</strong> <?php echo $website; ?>
                <?php endif; ?>
            </div>
            <div class="receipt-title">EXPENSE RECEIPT</div>
            <div class="receipt-number">#<?php echo $expense->reference_no; ?></div>
        </div>
        
        <div class="receipt-body">
            <div class="expense-details">
                <div class="detail-section">
                    <h3>Expense Information</h3>
                    <div class="detail-row">
                        <span class="detail-label">Date:</span>
                        <span class="detail-value"><?php echo show_date($expense->expense_date); ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Category:</span>
                        <span class="detail-value"><?php echo $expense->category_name; ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Expense For:</span>
                        <span class="detail-value"><?php echo $expense->expense_for; ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Payment Type:</span>
                        <span class="detail-value"><?php echo $expense->payment_type; ?></span>
                    </div>
                </div>
                
                <div class="detail-section">
                    <h3>Account Information</h3>
                    <div class="detail-row">
                        <span class="detail-label">Account:</span>
                        <span class="detail-value"><?php echo get_account_name($expense->account_id); ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Currency:</span>
                        <span class="detail-value"><?php echo $expense->currency_name . ' (' . $expense->currency_code . ')'; ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Expense Code:</span>
                        <span class="detail-value"><?php echo $expense->expense_code; ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="detail-label">Created By:</span>
                        <span class="detail-value"><?php echo $expense->created_by; ?></span>
                    </div>
                </div>
            </div>
            
            <div class="amount-section">
                <div class="amount-label">TOTAL AMOUNT PAID</div>
                <div class="amount-value">
                    <?php echo format_currency_with_system($expense->expense_amt, $expense->expense_currency_id); ?>
                </div>
                <div style="margin-top: 10px; font-size: 13px; color: #333;">
                    <strong>Amount in Words:</strong>
                    <?php echo no_to_words((float)$expense->expense_amt); ?> <?php echo isset($expense->currency_code) ? strtoupper($expense->currency_code) : ''; ?>
                </div>
                <?php if(isset($expense->exchange_rate) && $expense->exchange_rate != 1.0): ?>
                    <div style="margin-top: 15px; font-size: 14px; color: #666; border-top: 1px solid #ddd; padding-top: 10px;">
                        <strong>Exchange Details:</strong><br>
                        Rate: 1 <?php echo $expense->currency_code; ?> = <?php echo number_format($expense->exchange_rate, 4); ?> <?php echo $expense->base_currency_code; ?><br>
                        Base Amount: <?php echo format_currency_amount($expense->base_currency_amount, $expense->base_currency_id); ?>
                    </div>
                <?php endif; ?>
            </div>
            
            <?php if(!empty($expense->note)): ?>
            <div class="notes-section">
                <h4>Notes</h4>
                <div class="notes-content"><?php echo $expense->note; ?></div>
            </div>
            <?php endif; ?>
        </div>
        
        <div class="action-buttons">
            <button class="btn btn-primary" onclick="printReceipt('A4')">Print A4</button>
            <button class="btn btn-success" onclick="printReceipt('80mm')">Print 80mm</button>
            <button class="btn btn-primary" onclick="downloadPDF()">Download PDF</button>
        </div>
        
        <div class="footer">
            <p>Thank you for your business!</p>
            <p>Generated on <?php echo date('Y-m-d H:i:s'); ?></p>
        </div>
    </div>

    <script>
        function printReceipt(format) {
            // Set the print format
            if (format === '80mm') {
                document.body.style.maxWidth = '80mm';
                document.body.style.margin = '0 auto';
            } else {
                document.body.style.maxWidth = '800px';
                document.body.style.margin = '0 auto';
            }
            
            // Update document title with date
            var currentDate = new Date().toISOString().split('T')[0];
            document.title = 'Expense_Receipt_' + currentDate + '_' + '<?php echo $expense->reference_no; ?>';
            
            // Print
            window.print();
        }
        
        function downloadPDF() {
            // Update document title with date
            var currentDate = new Date().toISOString().split('T')[0];
            document.title = 'Expense_Receipt_' + currentDate + '_' + '<?php echo $expense->reference_no; ?>';
            
            // Trigger print dialog for PDF download
            window.print();
        }
    </script>
</body>
</html>
