<!DOCTYPE html>
<html>
<head>
    <!-- TABLES CSS CODE -->
    <?php include"comman/code_css.php"; ?>
    <style>
        .log-item {
            padding: 5px 0;
            border-bottom: 1px solid #dee2e6;
        }
        .log-item:last-child {
            border-bottom: none;
        }
        
        /* Mobile responsive styles */
        @media (max-width: 768px) {
            .btn-lg {
                padding: 8px 16px;
                font-size: 14px;
                margin: 5px;
            }
            .modal-dialog {
                margin: 10px;
            }
            .modal-body {
                padding: 15px;
            }
            .alert {
                margin-bottom: 10px;
                padding: 10px;
            }
            .box-body {
                padding: 15px;
            }
        }
        
        @media (max-width: 480px) {
            .btn-lg {
                width: 100%;
                margin: 5px 0;
            }
            .modal-dialog {
                margin: 5px;
            }
        }
    </style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
    <div class="wrapper">
        <?php include"sidebar.php"; ?>
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    <?=$page_title;?>
                    <small>Reset all POS data (Admin Only)</small>
                </h1>
                <ol class="breadcrumb">
                    <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                    <li><a href="#">Settings</a></li>
                    <li class="active"><?=$page_title;?></li>
                </ol>
            </section>
            
            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-md-12">
                        <div class="box box-danger">
                            <div class="box-header with-border">
                                <h3 class="box-title">
                                    <i class="fa fa-exclamation-triangle"></i> Data Reset
                                </h3>
                            </div>
                            <div class="box-body text-center">
                                <?php if (demo_app()): ?>
                                    <div class="alert alert-warning" style="margin-bottom: 20px;">
                                        <h4><i class="fa fa-info-circle"></i> Demo Mode Active</h4>
                                        <p><strong>Data reset functionality is disabled in demo mode.</strong></p>
                                        <p>This feature is read-only to prevent accidental data loss during demonstrations.</p>
                                    </div>
                                <?php else: ?>
                                    <p class="text-danger"><strong>⚠️ WARNING: This will delete ALL data!</strong></p>
                                <?php endif; ?>
                                
                                <div class="row" style="margin: 20px 0;">
                                    <div class="col-md-6 col-sm-12">
                                        <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>" id="csrf_token">
                                        <button type="button" class="btn btn-info btn-lg btn-block <?php echo demo_app() ? 'disabled' : ''; ?>" 
                                                onclick="<?php echo demo_app() ? 'showDemoModeMessage()' : 'createBackup()'; ?>" 
                                                <?php echo demo_app() ? 'disabled' : ''; ?>>
                                            <i class="fa fa-download"></i> Create Backup
                                        </button>
                                    </div>
                                    <div class="col-md-6 col-sm-12">
                                        <button type="button" class="btn btn-danger btn-lg btn-block <?php echo demo_app() ? 'disabled' : ''; ?>" 
                                                onclick="<?php echo demo_app() ? 'showDemoModeMessage()' : 'confirmReset()'; ?>" 
                                                <?php echo demo_app() ? 'disabled' : ''; ?>>
                                            <i class="fa fa-trash"></i> Reset Data
                                        </button>
                                    </div>
                                </div>
                                
                                <div id="status-message" class="alert" style="display: none;">
                                    <span id="status-text"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    <!-- Beautiful Modals -->
    
    <!-- Reset Confirmation Modal -->
    <div class="modal fade" id="resetModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-sm" role="document">
            <div class="modal-content">
                <div class="modal-header bg-danger">
                    <h4 class="modal-title">
                        <i class="fa fa-exclamation-triangle"></i> ⚠️ RESET DATA
                    </h4>
                </div>
                <div class="modal-body">
                    <div class="alert alert-danger" style="margin-bottom: 10px;">
                        <strong>This will DELETE ALL:</strong>
                        <ul style="margin: 5px 0; padding-left: 20px;">
                            <li>Sales, Purchases, Items</li>
                            <li>Customers, Stock, Payments</li>
                            <li>Expenses, Coupons, etc.</li>
                        </ul>
                    </div>
                    <div class="alert alert-info" style="margin-bottom: 10px;">
                        <small>Walk-in customers preserved. Cash accounts reset to 0.</small>
                    </div>
                    <div class="form-group">
                        <label for="confirmText">Type "RESET" to confirm:</label>
                        <input type="text" class="form-control" id="confirmText" placeholder="Type: RESET">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default btn-sm" data-dismiss="modal">
                        <i class="fa fa-times"></i> Cancel
                    </button>
                    <button type="button" class="btn btn-danger btn-sm" onclick="proceedReset()" id="confirmBtn" disabled>
                        <i class="fa fa-trash"></i> RESET
                    </button>
                </div>
            </div>
        </div>
    </div>


    <!-- Error Modal -->
    <div class="modal fade" id="errorModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-sm" role="document">
            <div class="modal-content">
                <div class="modal-header bg-danger">
                    <h4 class="modal-title">
                        <i class="fa fa-exclamation-circle"></i> Error
                    </h4>
                </div>
                <div class="modal-body">
                    <p id="errorMessage">An error occurred. Please try again.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger btn-sm" data-dismiss="modal">
                        <i class="fa fa-times"></i> OK
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- /.content-wrapper -->
    <?php include"footer.php"; ?>
    <!-- Add the sidebar's background. This div must be placed
         immediately after the control sidebar -->
    <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- SOUND CODE -->
<?php include"comman/code_js_sound.php"; ?>
<!-- TABLES CODE -->
<?php include"comman/code_js.php"; ?>
    <script>
        function showDemoModeMessage() {
            showErrorModal('This feature is disabled in demo mode. Data reset functionality is read-only during demonstrations to prevent accidental data loss.');
        }
        
        function createBackup() {
            showStatus('Creating backup...', 'info');
            $('.btn-info').html('<i class="fa fa-spinner fa-spin"></i> Creating...').prop('disabled', true);
            
            $.ajax({
                url: '<?= base_url("data_reset/backup_before_reset"); ?>',
                type: 'POST',
                dataType: 'text',
                data: {
                    '<?php echo $this->security->get_csrf_token_name(); ?>': $('#csrf_token').val()
                },
                    success: function(response) {
                        if (response.startsWith('success|')) {
                            showStatus(response.substring(8), 'success');
                        } else if (response.startsWith('error|')) {
                            showErrorModal(response.substring(6));
                            showStatus(response.substring(6), 'danger');
                        } else {
                            showStatus('Backup created: ' + response, 'success');
                        }
                    },
                error: function() {
                    showErrorModal('Backup failed. Please try again.');
                    showStatus('Backup failed. Try again.', 'danger');
                },
                complete: function() {
                    $('.btn-info').html('<i class="fa fa-download"></i> Create Backup').prop('disabled', false);
                }
            });
        }


        function confirmReset() {
            $('#resetModal').modal('show');
        }

        function proceedReset() {
            var confirmText = $('#confirmText').val();
            if (confirmText === 'RESET') {
                $('#resetModal').modal('hide');
                resetAllData();
            } else {
                alert('You must type "RESET" to confirm.');
            }
        }

        function resetAllData() {
            showStatus('Resetting data...', 'warning');
            $('.btn-danger').html('<i class="fa fa-spinner fa-spin"></i> Resetting...').prop('disabled', true);
            
            $.ajax({
                url: '<?= base_url("data_reset/reset_all_data"); ?>',
                type: 'POST',
                dataType: 'json',
                data: {
                    '<?php echo $this->security->get_csrf_token_name(); ?>': $('#csrf_token').val()
                },
                    success: function(response) {
                        if (response.status === 'success') {
                            showStatus('Reset completed! All data cleared. Redirecting to login...', 'success');
                            $('.btn-danger').html('<i class="fa fa-check"></i> Done').removeClass('btn-danger').addClass('btn-success');
                            
                            // Redirect to login after 3 seconds
                            setTimeout(function() {
                                window.location.href = '<?= base_url("login"); ?>';
                            }, 3000);
                        } else {
                            showErrorModal('Reset failed: ' + response.message);
                            showStatus('Reset failed: ' + response.message, 'danger');
                            $('.btn-danger').html('<i class="fa fa-trash"></i> Reset Data').prop('disabled', false);
                        }
                    },
                error: function(xhr, status, error) {
                    var errorMsg = 'Reset failed. ';
                    if (xhr.responseText) {
                        try {
                            var response = JSON.parse(xhr.responseText);
                            errorMsg += response.message || error;
                        } catch(e) {
                            errorMsg += xhr.responseText || error;
                        }
                    } else {
                        errorMsg += error;
                    }
                    showErrorModal(errorMsg);
                    showStatus(errorMsg, 'danger');
                    $('.btn-danger').html('<i class="fa fa-trash"></i> Reset Data').prop('disabled', false);
                }
            });
        }

        function showStatus(message, type) {
            $('#status-message').removeClass('alert-info alert-success alert-warning alert-danger')
                               .addClass('alert-' + type)
                               .show();
            $('#status-text').text(message);
            
            // Auto-hide success messages after 5 seconds
            if (type === 'success') {
                setTimeout(function() {
                    $('#status-message').fadeOut();
                }, 5000);
            }
        }


        function showErrorModal(message) {
            $('#errorMessage').text(message);
            $('#errorModal').modal('show');
        }

        // Enable/disable confirm button based on text input
        $(document).ready(function() {
            $('#confirmText').on('input', function() {
                if ($(this).val() === 'RESET') {
                    $('#confirmBtn').prop('disabled', false);
                } else {
                    $('#confirmBtn').prop('disabled', true);
                }
            });
            
            // Reset form when modal is closed
            $('#resetModal').on('hidden.bs.modal', function() {
                $('#confirmText').val('');
                $('#confirmBtn').prop('disabled', true);
            });
        });
    </script>
</body>
</html>
