<!-- Batch Details Modal for Purchase Items -->
<div class="modal fade" id="batch_details_modal" tabindex="-1" role="dialog" aria-labelledby="batch_details_modal_label">
   <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
         <div class="modal-header bg-primary">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
               <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title" id="batch_details_modal_label">
               <i class="fa fa-calendar"></i> Batch Details
            </h4>
         </div>
         <div class="modal-body">
            <form id="batch_details_form">
               <div class="row">
                  <div class="form-group col-md-6">
                     <label for="batch_number">Batch Number <span class="text-danger">*</span></label>
                     <input type="text" class="form-control" id="batch_number" name="batch_number" placeholder="Enter batch number" required>
                     <span id="batch_number_msg" style="display:none" class="text-danger"></span>
                  </div>
                  <div class="form-group col-md-6">
                     <label for="batch_quantity">Quantity <span class="text-danger">*</span></label>
                     <input type="number" class="form-control" id="batch_quantity" name="batch_quantity" placeholder="Enter quantity" min="0.01" step="0.01" required>
                     <span id="batch_quantity_msg" style="display:none" class="text-danger"></span>
                  </div>
               </div>
               <div class="row">
                  <div class="form-group col-md-6">
                     <label for="manufacturing_date">Manufacturing Date</label>
                     <div class="input-group date">
                        <input type="text" class="form-control datepicker" id="manufacturing_date" name="manufacturing_date" placeholder="Select manufacturing date" readonly>
                        <div class="input-group-addon">
                           <i class="fa fa-calendar"></i>
                        </div>
                     </div>
                     <span id="manufacturing_date_msg" style="display:none" class="text-danger"></span>
                  </div>
                  <div class="form-group col-md-6">
                     <label for="expiry_date">Expiry Date</label>
                     <div class="input-group date">
                        <input type="text" class="form-control datepicker" id="expiry_date" name="expiry_date" placeholder="Select expiry date" readonly>
                        <div class="input-group-addon">
                           <i class="fa fa-calendar"></i>
                        </div>
                     </div>
                     <span id="expiry_date_msg" style="display:none" class="text-danger"></span>
                  </div>
               </div>
               <div class="row">
                  <div class="form-group col-md-12">
                     <label for="batch_notes">Notes</label>
                     <textarea class="form-control" id="batch_notes" name="batch_notes" rows="2" placeholder="Additional notes for this batch"></textarea>
                  </div>
               </div>
            </form>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">
               <i class="fa fa-times"></i> Cancel
            </button>
            <button type="button" class="btn btn-primary" id="save_batch_details">
               <i class="fa fa-save"></i> Save Batch Details
            </button>
         </div>
      </div>
   </div>
</div>

