<!-- Batch Selection Modal for Sales -->
<div class="modal fade" id="sales_batch_selection_modal" tabindex="-1" role="dialog" aria-labelledby="sales_batch_selection_modalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="sales_batch_selection_modalLabel">
                    <i class="fa fa-cubes"></i> Select Batch for <span id="modal_item_name_sales"></span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> 
                            <strong>Available Batches:</strong> Select a batch to sell from. Stock quantities and expiry dates are shown below.
                            <br><small><strong>FIFO:</strong> Batches are ordered by expiry date (First In, First Out) to ensure proper inventory rotation.</small>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12 text-center">
                        <button type="button" class="btn btn-success btn-lg" id="auto_select_fifo_btn" onclick="handleAutoSelectFIFO()">
                            <i class="fa fa-magic"></i> Auto-Select FIFO Batches
                        </button>
                        <small class="text-muted d-block" style="margin-top: 5px;">Automatically selects batches that expire first</small>
                    </div>
                </div>
                
                <div class="row" style="margin-top: 15px;">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="batch_selection_table">
                                <thead>
                                    <tr>
                                        <th>Batch Number</th>
                                        <th>Manufacturing Date</th>
                                        <th>Expiry Date</th>
                                        <th>Days to Expiry</th>
                                        <th>Available Stock</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody id="batch_selection_tbody">
                                    <!-- Batches will be loaded here via AJAX -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                
                <div class="row" id="no_batches_message" style="display: none;">
                    <div class="col-md-12">
                        <div class="alert alert-warning text-center">
                            <i class="fa fa-exclamation-triangle"></i>
                            <strong>No batches available!</strong><br>
                            This item has batch tracking enabled but no batches are available for sale.
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">
                    <i class="fa fa-times"></i> Cancel
                </button>
            </div>
        </div>
    </div>
</div>

<style>
/* Batch selection modal styling */
#sales_batch_selection_modal .modal-dialog {
    max-width: 900px;
}

#batch_selection_table th {
    background-color: #f5f5f5;
    font-weight: bold;
    text-align: center;
}

#batch_selection_table td {
    text-align: center;
    vertical-align: middle;
}

.batch-row {
    cursor: pointer;
}

.batch-row:hover {
    background-color: #f9f9f9;
}

.batch-row.selected {
    background-color: #e8f5e8;
    border: 2px solid #5cb85c;
}

.expiry-warning {
    color: #d9534f;
    font-weight: bold;
}

.expiry-critical {
    color: #d9534f;
    font-weight: bold;
    background-color: #f2dede;
}

.expiry-good {
    color: #5cb85c;
    font-weight: bold;
}

.stock-low {
    color: #f0ad4e;
    font-weight: bold;
}

.stock-out {
    color: #d9534f;
    font-weight: bold;
    background-color: #f2dede;
}
</style>

<script>
// Handle Auto-Select FIFO based on context (Sales vs POS)
function handleAutoSelectFIFO() {
    // Check if we're in POS context by looking for POS-specific elements
    if (typeof window.current_pos_batch_row_id !== 'undefined' && window.current_pos_batch_row_id !== null) {
        // POS context
        console.log('Using POS FIFO auto-select');
        autoSelectFIFOPOS();
    } else {
        // Sales context
        console.log('Using Sales FIFO auto-select');
        autoSelectFIFO();
    }
}
</script>
