<!DOCTYPE html>
<html>
<head>
<!-- TABLES CSS CODE -->
<?php $this->load->view('comman/code_css.php');?>
<!-- </copy> -->  
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <?php $this->load->view('sidebar');?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        <?= $this->lang->line('invoice'); ?>
      </h1>
      <ol class="breadcrumb">
        <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="<?php echo $base_url; ?>quotation"><?= $this->lang->line('quotation_list'); ?></a></li>
        <li><a href="<?php echo $base_url; ?>quotation/add"><?= $this->lang->line('new_quotation'); ?></a></li>
        <li class="active"><?= $this->lang->line('invoice'); ?></li>
      </ol>
    </section>
    <div class="row">
      <div class="col-md-12">
      <!-- ********** ALERT MESSAGE START******* -->
      <?php $this->load->view('comman/code_flashdata');?>
      <!-- ********** ALERT MESSAGE END******* -->
      </div>
    </div>
    <?php
    $CI =& get_instance();
    
    // Helper function to format currency with correct symbol
    function format_currency_with_symbol($amount, $symbol) {
        return $symbol . ' ' . number_format($amount, 2);
    }
    
    $q3=$this->db->query("SELECT b.expire_date, b.sales_status, b.store_id,a.customer_name,a.mobile,a.phone,a.gstin,a.tax_number,a.email,
                           a.opening_balance,a.country_id,a.state_id,a.city,
                           a.postcode,a.address,b.quotation_date,b.created_time,b.reference_no,
                           b.quotation_code,b.quotation_status,b.quotation_note,
                           coalesce(b.grand_total,0) as grand_total,
                           coalesce(b.subtotal,0) as subtotal,
                           coalesce(b.paid_amount,0) as paid_amount,
                           coalesce(b.other_charges_input,0) as other_charges_input,
                           other_charges_tax_id,
                           coalesce(b.other_charges_amt,0) as other_charges_amt,
                           discount_to_all_input,
                           b.discount_to_all_type,
                           coalesce(b.tot_discount_to_all_amt,0) as tot_discount_to_all_amt,
                           coalesce(b.round_off,0) as round_off,
                           b.payment_status,b.pos,
                           b.quotation_currency_id, b.exchange_rate, b.base_currency_total,
                           c.currency_name, c.currency_code, c.symbol as currency_symbol

                           FROM db_customers a,
                           db_quotation b 
                           LEFT JOIN db_currency c ON b.quotation_currency_id = c.id
                           WHERE 
                           a.`id`=b.`customer_id` AND 
                           b.`id`='$quotation_id' AND b.store_id=".get_current_store_id());
                        
    
    $res3=$q3->row();
    if($res3->store_id!=get_current_store_id()){
      $CI->show_access_denied_page();exit();
    }
    
    // Determine currency symbol to use (same logic as purchase invoice)
    $currency_symbol = '$'; // Default to base currency
    if (!empty($res3->quotation_currency_id) && !empty($res3->currency_symbol)) {
        $currency_symbol = $res3->currency_symbol;
    } else {
        // Fallback to base currency
        if (function_exists('get_base_currency')) {
            $base_currency = get_base_currency();
            $currency_symbol = $base_currency->symbol;
        } else {
            $currency_symbol = '$'; // Ultimate fallback
        }
    }
    $customer_name=$res3->customer_name;
    $customer_mobile=$res3->mobile;
    $customer_phone=$res3->phone;
    $customer_email=$res3->email;
    $customer_country=get_country($res3->country_id);
    $customer_state=get_state($res3->state_id);
    $customer_city=$res3->city;
    $customer_address=$res3->address;
    $customer_postcode=$res3->postcode;
    $customer_gst_no=$res3->gstin;
    $customer_tax_number=$res3->tax_number;
    $customer_opening_balance=$res3->opening_balance;
    $quotation_date=$res3->quotation_date;
    $expire_date=(!empty($res3->expire_date)) ? show_date($res3->expire_date) : '';
    $created_time=$res3->created_time;
    $reference_no=$res3->reference_no;
    $quotation_code=$res3->quotation_code;
    $quotation_status=$res3->quotation_status;
    $quotation_note=$res3->quotation_note;
    $sales_status=$res3->sales_status;

    
    $subtotal=$res3->subtotal;
    $grand_total=$res3->grand_total;
    $other_charges_input=$res3->other_charges_input;
    $other_charges_tax_id=$res3->other_charges_tax_id;
    $other_charges_amt=$res3->other_charges_amt;
    $paid_amount=$res3->paid_amount;
    $discount_to_all_input=$res3->discount_to_all_input;
    $discount_to_all_type=$res3->discount_to_all_type;
    $discount_to_all_type = ($discount_to_all_type=='in_percentage') ? '%' : 'Fixed';
    $tot_discount_to_all_amt=$res3->tot_discount_to_all_amt;
    $round_off=$res3->round_off;
    $payment_status=$res3->payment_status;
    $pos=$res3->pos;
    
    

    $q1=$this->db->query("select * from db_store where id=".$res3->store_id." ");
    $res1=$q1->row();
    $store_name=$res1->store_name;
    $company_mobile=$res1->mobile;
    $company_phone=$res1->phone;
    $company_email=$res1->email;
    //$company_country=$res1->country;
    //$company_state=$res1->state;
    $company_city=$res1->city;
    $company_address=$res1->address;
    $company_gst_no=$res1->gst_no;
    $company_vat_no=$res1->vat_no;
    $company_pan_no=$res1->pan_no;
    
    ?>


    <!-- Main content -->
    <section class="invoice">
      <!-- title row -->
      <div class="printableArea">
      <div class="row">
        <div class="col-xs-12">
          <h2 class="page-header">
            <i class="fa fa-globe"></i> <?= $this->lang->line('quotation_invoice'); ?>
            <small class="pull-right">Date: <?php echo  show_date($quotation_date)." ".$created_time; ?></small>
          </h2>
        </div>
        <!-- /.col -->
      </div>
      <!-- info row -->
      <div class="row invoice-info">
        <div class="col-sm-4 invoice-col">
          <i><?= $this->lang->line('from'); ?></i>
          <address>
            <strong><?php echo  $store_name; ?></strong><br>
            <?php echo  $company_address; ?>,
            <?= $this->lang->line('city'); ?>:<?php echo  $company_city; ?><br>
            <?= $this->lang->line('phone'); ?>: <?php echo  $company_phone; ?>,
            <?= $this->lang->line('mobile'); ?>: <?php echo  $company_mobile; ?><br>
            <?php echo (!empty(trim($company_email))) ? $this->lang->line('email').": ".$company_email."<br>" : '';?>
            <?php echo (!empty(trim($company_gst_no)) && gst_number()) ? $this->lang->line('gst_number').": ".$company_gst_no."<br>" : '';?>
            <?php echo (!empty(trim($company_vat_no)) && vat_number()) ? $this->lang->line('vat_number').": ".$company_vat_no."<br>" : '';?>
            <?php echo (!empty(trim($company_pan_no)) && pan_number()) ? $this->lang->line('pan_number').": ".$company_pan_no."<br>" : '';?>
           
          </address>
        </div>
        <!-- /.col -->
        <div class="col-sm-4 invoice-col">
          <i><?= $this->lang->line('customer_details'); ?><br></i>
          <address>
            <strong><?php echo  $customer_name; ?></strong><br>
            <?php 
              if(!empty($customer_address)){
                echo $customer_address;
              }
              if(!empty($customer_country)){
                echo $customer_country;
              }
              if(!empty($customer_state)){
                echo ",".$customer_state;
              }
              if(!empty($customer_city)){
                echo ",".$customer_city;
              }
              if(!empty($customer_postcode)){
                echo "-".$customer_postcode;
              }
            ?>
            <br>
            <?php echo (!empty(trim($customer_mobile))) ? $this->lang->line('mobile').": ".$customer_mobile."<br>" : '';?>
            <?php echo (!empty(trim($customer_phone))) ? $this->lang->line('phone').": ".$customer_phone."<br>" : '';?>
            <?php echo (!empty(trim($customer_email))) ? $this->lang->line('email').": ".$customer_email."<br>" : '';?>
            <?php echo (!empty(trim($customer_gst_no)) && gst_number()) ? $this->lang->line('gst_number').": ".$customer_gst_no."<br>" : '';?>
            <?php echo (!empty(trim($customer_tax_number))) ? $this->lang->line('tax_number').": ".$customer_tax_number."<br>" : '';?>
          </address>
        </div>
        <!-- /.col -->
        <div class="col-sm-4 invoice-col">
          <b><?= $this->lang->line('invoice'); ?> #<?php echo  $quotation_code; ?></b><br>

          <?php if($sales_status=='Converted'){ ?>
            <b><?= $this->lang->line('sales_invoice'); ?> #<a title="View to Invoice" href="<?=base_url()?>sales/invoice/<?=get_sales_id_of_quotation($quotation_id)?>" ><?= get_sales_code(get_sales_id_of_quotation($quotation_id)); ?></a></b><br>
          <?php } ?>

          <b><?= $this->lang->line('reference_no'); ?> :<?php echo  $reference_no; ?></b><br>
          <b><?= $this->lang->line('expire_date'); ?> :<?php echo  $expire_date; ?></b><br>
         
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->

      <!-- Table row -->
      <div class="row">
        <div class="col-xs-12 table-responsive">
          <table class="table  records_table table-bordered">
            <thead class="bg-gray-active">
            <tr>
              <th>#</th>
              <th><?= $this->lang->line('item_name'); ?></th>
              <th><?= $this->lang->line('unit_price'); ?></th>
              <th><?= $this->lang->line('quantity'); ?></th>
              <th><?= $this->lang->line('net_cost'); ?></th>
              <th><?= $this->lang->line('tax'); ?></th>
              <th><?= $this->lang->line('tax_amount'); ?></th>
              <th><?= $this->lang->line('discount'); ?></th>
              <th><?= $this->lang->line('discount_amount'); ?></th>
              <th><?= $this->lang->line('unit_cost'); ?></th>
              <th><?= $this->lang->line('total_amount'); ?></th>
            </tr>
            </thead>
            <tbody>

              <?php
              $i=0;
              $tot_qty=0;
              $tot_quotation_price=0;
              $tot_tax_amt=0;
              $tot_discount_amt=0;
              $tot_total_cost=0;

              $q2=$this->db->query("SELECT a.description,c.item_name, a.quotation_qty,a.tax_type,
                                  a.price_per_unit, b.tax,b.tax_name,a.tax_amt,
                                  a.discount_input,a.discount_amt, a.unit_total_cost,
                                  a.total_cost 
                                  FROM 
                                  db_quotationitems AS a,db_tax AS b,db_items AS c 
                                  WHERE 
                                  c.id=a.item_id AND b.id=a.tax_id AND a.quotation_id='$quotation_id'");
              foreach ($q2->result() as $res2) {
                  $str = ($res2->tax_type=='Inclusive')? 'Inc.' : 'Exc.';
                  $discount = (empty($res2->discount_input)||$res2->discount_input==0)? '0':$res2->discount_input."%";
                  $discount_amt = (empty($res2->discount_amt)||$res2->discount_input==0)? '0':$res2->discount_amt."";
                  echo "<tr>";  
                  echo "<td>".++$i."</td>";
                  echo "<td>";
                    echo $res2->item_name;
                    echo (!empty($res2->description)) ? "<br><i>[".nl2br($res2->description)."]</i>" : '';
                  echo "</td>";
                  echo "<td class='text-right'>".format_currency_with_symbol($res2->price_per_unit, $currency_symbol)."</td>";
                  echo "<td>".format_qty($res2->quotation_qty)."</td>";
                  echo "<td class='text-right'>".format_currency_with_symbol(($res2->price_per_unit * $res2->quotation_qty), $currency_symbol)."</td>";
                  
                  echo "<td>".store_number_format($res2->tax)."%<br>".$res2->tax_name."[".$str."]</td>";
                  echo "<td class='text-right'>".format_currency_with_symbol($res2->tax_amt, $currency_symbol)."</td>";
                  echo "<td class='text-right'>".$discount."</td>";
                  echo "<td class='text-right'>".format_currency_with_symbol($discount_amt, $currency_symbol)."</td>";
                  echo "<td class='text-right'>".format_currency_with_symbol($res2->unit_total_cost, $currency_symbol)."</td>";
                  echo "<td class='text-right'>".format_currency_with_symbol($res2->total_cost, $currency_symbol)."</td>";
                  echo "</tr>";  
                  $tot_qty +=$res2->quotation_qty;
                  $tot_quotation_price +=$res2->price_per_unit;
                  $tot_tax_amt +=$res2->tax_amt;
                  $tot_discount_amt +=$res2->discount_amt;
                  $tot_total_cost +=$res2->total_cost;
              }
              ?>
         
      
            </tbody>
            <tfoot class="text-right text-bold bg-gray">
              <tr>
                <td colspan="2" class="text-center">Total</td>
                <td><?= format_currency_with_symbol($tot_quotation_price, $currency_symbol);?></td>
                <td class="text-left"><?=format_qty($tot_qty);?></td>
                <td>-</td>
                <td>-</td>
                <td><?= format_currency_with_symbol($tot_tax_amt, $currency_symbol);?></td>
                <td>-</td>
                <td><?= format_currency_with_symbol($tot_discount_amt, $currency_symbol) ;?></td>
                <td>-</td>
                <td><?= format_currency_with_symbol($tot_total_cost, $currency_symbol) ;?></td>
              </tr>
            </tfoot>
          </table>
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    
      <div class="row">
       <div class="col-md-6">
           <div class="row">
              <div class="col-md-12">
                 <div class="form-group">
                    <label for="discount_to_all_input" class="col-sm-4 control-label" style="font-size: 17px;"><?= $this->lang->line('discount_on_all'); ?></label>    
                    <div class="col-sm-8">
                       <label class="control-label  " style="font-size: 17px;">: <?=store_number_format($discount_to_all_input); ?> (<?= $discount_to_all_type ?>)</label>
                    </div>
                 </div>
              </div>
           </div>
          <div class="row">
              <div class="col-md-12">
                 <div class="form-group">
                    <label for="quotation_note" class="col-sm-4 control-label" style="font-size: 17px;"><?= $this->lang->line('note'); ?></label>    
                    <div class="col-sm-8">
                       <label class="control-label  " style="font-size: 17px;">: <?=$quotation_note;?></label>
                    </div>
                 </div>
              </div>
           </div> 
                     
        </div>

        <div class="col-md-6">
           <div class="row">
              <div class="col-md-12">
                 <div class="form-group">
                     
                    <table  class="col-md-11">
                       <tr>
                          <th class="text-right" style="font-size: 17px;"><?= $this->lang->line('subtotal'); ?></th>
                          <th class="text-right" style="padding-left:10%;font-size: 17px;">
                             <h4><b id="subtotal_amt" name="subtotal_amt"><?=format_currency_with_symbol($subtotal, $currency_symbol);?></b></h4>
                          </th>
                       </tr>
                       <tr>
                          <th class="text-right" style="font-size: 17px;"><?= $this->lang->line('other_charges'); ?></th>
                          <th class="text-right" style="padding-left:10%;font-size: 17px;">
                             <h4><b id="other_charges_amt" name="other_charges_amt"><?=format_currency_with_symbol($other_charges_amt, $currency_symbol);?></b></h4>
                          </th>
                       </tr>
                       <tr>
                          <th class="text-right" style="font-size: 17px;"><?= $this->lang->line('discount_on_all'); ?></th>
                          <th class="text-right" style="padding-left:10%;font-size: 17px;">
                             <h4><b id="discount_to_all_amt" name="discount_to_all_amt"><?=format_currency_with_symbol($tot_discount_to_all_amt, $currency_symbol);?></b></h4>
                          </th>
                       </tr>
                       <tr>
                          <th class="text-right" style="font-size: 17px;"><?= $this->lang->line('round_off'); ?></th>
                          <th class="text-right" style="padding-left:10%;font-size: 17px;">
                             <h4><b id="round_off_amt" name="tot_round_off_amt"><?=format_currency_with_symbol($round_off, $currency_symbol);?></b></h4>
                          </th>
                       </tr>
                       <tr>
                          <th class="text-right" style="font-size: 17px;"><?= $this->lang->line('grand_total'); ?></th>
                          <th class="text-right" style="padding-left:10%;font-size: 17px;">
                             <h4><b id="total_amt" name="total_amt"><?=format_currency_with_symbol($grand_total, $currency_symbol);?></b></h4>
                          </th>
                       </tr>
                    </table>
                 </div>
              </div>
           </div>
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->

    </div><!-- printableArea -->
      <!-- this row will not appear when printing -->
      <div class="row no-print">
        <div class="col-xs-6">
          <?php if($CI->permissions('quotation_edit')) { ?>
          <?php $str2= ($pos==1)? 'pos/edit/':'quotation/update/'; ?>
          <a href="<?php echo $base_url; ?><?=$str2;?><?php echo  $quotation_id ?>" class="btn btn-success">
            <i class="fa  fa-edit"></i> Edit
          </a>
        <?php } ?>

         
        
          <?php if($CI->permissions('sales_add') && $sales_status=='') { ?>
            <a href="<?php echo $base_url; ?>sales/quotation/<?php echo  $quotation_id ?>" class="btn btn-danger">
            <i class="fa  fa-undo"></i> Convert to Invoice
          </a>
          <?php }else{ ?>
            <a href="<?php echo $base_url; ?>sales/invoice/<?=get_sales_id_of_quotation($quotation_id)?>" class="btn btn-danger">
            <i class="fa  fa-eye"></i> View Sales Invoice
          </a>
          <?php } ?>
          
          
        </div>
        <div class="col-xs-6 text-right">
          <a href="<?php echo $base_url; ?>quotation/print_invoice/<?php echo  $quotation_id ?>" target="_blank" class="btn btn-warning">
            <i class="fa fa-print"></i> 
          Print
        </a>
        
        <a href="<?php echo $base_url; ?>quotation/pdf/<?php echo  $quotation_id ?>" target="_blank" class="btn btn-primary">
            <i class="fa fa-file-pdf-o"></i> 
          PDF
        </a>
        </div>
      </div>

    </section>
    <!-- /.content -->
    <div class="clearfix"></div>
  </div>
  <!-- /.content-wrapper -->
  <?php $this->load->view('footer');?>

 
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- SOUND CODE -->
<?php $this->load->view('comman/code_js_sound');?>
<!-- TABLES CODE -->
<?php $this->load->view('comman/code_js');?>

<!-- Make sidebar menu hughlighter/selector -->
<script>$(".quotation_list-active-li").addClass("active");</script>
</body>
</html>
