<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title><?php print $SITE_TITLE; ?> | Register</title>
  <link rel='shortcut icon' href='<?php echo $theme_link; ?>images/favicon.ico' />
  <!-- Tell the browser to be responsive to screen width -->
  <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
  <!-- Bootstrap 3.3.6 -->
  <link rel="stylesheet" href="<?php echo $theme_link; ?>bootstrap/css/bootstrap.min.css">
   <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo $theme_link; ?>css/font-awesome-4.7.0/css/font-awesome.min.css">
  <!-- Ionicons -->
  <link rel="stylesheet" href="<?php echo $theme_link; ?>css/ionicons-2.0.1/css/ionicons.min.css">
  <!-- Select2 -->
  <link rel="stylesheet" href="<?php echo $theme_link; ?>plugins/select2/select2.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo $theme_link; ?>dist/css/AdminLTE.min.css">
  <!--Toastr notification -->
  <link rel="stylesheet" href="<?php echo $theme_link; ?>toastr/toastr.css">
  <!-- iCheck -->
  <link rel="stylesheet" href="<?php echo $theme_link; ?>plugins/iCheck/square/blue.css">
  <?php 
      $lang = trim(strtoupper($this->session->userdata('language')));
      if($lang==strtoupper('arabic') || $lang==strtoupper('urdu')) {?>
  <!-- RTL For arabic styles -->
  <link rel="stylesheet" href="<?php echo $theme_link; ?>bootstrap/css/bootstrap.rtl.min.css">
  <link rel="stylesheet" href="<?php echo $theme_link; ?>dist/css/AdminLTE.rtl.min.css">
  <?php } ?>
  
  <!-- Modern Registration Styles -->
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 20px;
    }

    .auth-container {
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(10px);
      border-radius: 15px;
      box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
      padding: 30px;
      width: 100%;
      max-width: 500px;
      position: relative;
      overflow: hidden;
    }

    .auth-container::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 3px;
      background: linear-gradient(90deg, #667eea, #764ba2, #f093fb);
    }

    .auth-header {
      text-align: center;
      margin-bottom: 25px;
    }

    .auth-logo {
      margin: 0 auto 15px;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .auth-logo img {
      max-width: 120px;
      max-height: 60px;
      width: auto;
      height: auto;
    }

    .auth-title {
      font-size: 24px;
      font-weight: 700;
      color: #2d3748;
      margin-bottom: 5px;
    }

    .auth-subtitle {
      color: #718096;
      font-size: 14px;
      line-height: 1.4;
    }

    /* Step Progress */
    .step-progress {
      display: flex;
      justify-content: center;
      margin-bottom: 40px;
      position: relative;
    }

    .step {
      display: flex;
      align-items: center;
      position: relative;
    }

    .step-circle {
      width: 40px;
      height: 40px;
      border-radius: 50%;
      background: #e2e8f0;
      color: #a0aec0;
      display: flex;
      align-items: center;
      justify-content: center;
      font-weight: 600;
      font-size: 14px;
      transition: all 0.3s ease;
      position: relative;
      z-index: 2;
    }

    .step.active .step-circle {
      background: linear-gradient(135deg, #667eea, #764ba2);
      color: white;
      box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
    }

    .step.completed .step-circle {
      background: #38a169;
      color: white;
    }

    .step.completed .step-circle::before {
      content: '✓';
      font-size: 16px;
    }

    .step-label {
      margin-left: 10px;
      font-size: 14px;
      font-weight: 500;
      color: #4a5568;
    }

    .step.active .step-label {
      color: #667eea;
    }

    .step.completed .step-label {
      color: #38a169;
    }

    .step-line {
      width: 60px;
      height: 2px;
      background: #e2e8f0;
      margin: 0 10px;
      transition: all 0.3s ease;
    }

    .step.completed + .step .step-line {
      background: #38a169;
    }

    /* Form Steps */
    .form-step {
      display: none;
      animation: fadeIn 0.3s ease;
    }

    .form-step.active {
      display: block;
    }

    @keyframes fadeIn {
      from { opacity: 0; transform: translateY(20px); }
      to { opacity: 1; transform: translateY(0); }
    }

    .form-group {
      margin-bottom: 20px;
      position: relative;
    }

    .form-control {
      width: 100%;
      padding: 12px 15px 12px 45px;
      border: 2px solid #e2e8f0;
      border-radius: 8px;
      font-size: 14px;
      transition: all 0.3s ease;
      background: #f8fafc;
    }

    .form-control:focus {
      outline: none;
      border-color: #667eea;
      background: #fff;
      box-shadow: 0 0 0 2px rgba(102, 126, 234, 0.1);
    }

    .form-control::placeholder {
      color: #a0aec0;
    }

    .input-icon {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      color: #a0aec0;
      font-size: 16px;
      transition: color 0.3s ease;
    }

    .form-control:focus + .input-icon {
      color: #667eea;
    }

    .select2-container .select2-selection--single {
      height: 50px;
      border: 2px solid #e2e8f0;
      border-radius: 12px;
      background: #f8fafc;
    }

    .select2-container--default .select2-selection--single .select2-selection__rendered {
      line-height: 46px;
      padding-left: 50px;
      color: #4a5568;
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow {
      height: 46px;
      right: 15px;
    }

    .select2-container--default.select2-container--focus .select2-selection--single {
      border-color: #667eea;
      box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .btn-step {
      padding: 10px 25px;
      border: none;
      border-radius: 6px;
      font-size: 13px;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
    }

    .btn-primary {
      background: linear-gradient(135deg, #667eea, #764ba2);
      color: white;
    }

    .btn-primary:hover {
      transform: translateY(-2px);
      box-shadow: 0 10px 25px rgba(102, 126, 234, 0.4);
    }

    .btn-secondary {
      background: #e2e8f0;
      color: #4a5568;
    }

    .btn-secondary:hover {
      background: #cbd5e0;
      transform: translateY(-1px);
    }

    .btn-submit {
      width: 100%;
      padding: 12px;
      background: linear-gradient(135deg, #38a169, #2f855a);
      border: none;
      border-radius: 8px;
      color: white;
      font-size: 14px;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
    }

    .btn-submit:hover {
      transform: translateY(-2px);
      box-shadow: 0 10px 25px rgba(56, 161, 105, 0.4);
    }

    .btn-submit:disabled {
      opacity: 0.7;
      cursor: not-allowed;
      transform: none;
    }

    .step-buttons {
      display: flex;
      justify-content: space-between;
      margin-top: 25px;
      gap: 10px;
    }

    .auth-links {
      display: flex;
      justify-content: center;
      margin-top: 25px;
      flex-wrap: wrap;
      gap: 10px;
    }

    .auth-link {
      color: #667eea;
      text-decoration: none;
      font-weight: 500;
      transition: color 0.3s ease;
    }

    .auth-link:hover {
      color: #764ba2;
      text-decoration: none;
    }

    .alert {
      padding: 12px 16px;
      border-radius: 8px;
      margin-bottom: 20px;
      font-weight: 500;
    }

    .alert-danger {
      background: #fed7d7;
      color: #c53030;
      border: 1px solid #feb2b2;
    }

    .alert-success {
      background: #c6f6d5;
      color: #2f855a;
      border: 1px solid #9ae6b4;
    }

    .alert-warning {
      background: #fef5e7;
      color: #d69e2e;
      border: 1px solid #fbd38d;
    }

    .alert-info {
      background: #bee3f8;
      color: #2b6cb0;
      border: 1px solid #90cdf4;
    }

    .language-selector {
      margin-top: 20px;
      text-align: center;
    }

    .language_id {
      border: 2px solid #e2e8f0;
      border-radius: 8px;
      padding: 10px 15px;
      font-size: 14px;
      color: #4a5568;
      background: #f8fafc;
      transition: all 0.3s ease;
      min-width: 200px;
    }

    .language_id:focus {
      outline: none;
      border-color: #667eea;
      background: #fff;
      box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .demo-section {
      background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
      border-radius: 15px;
      padding: 20px;
      margin-top: 20px;
      color: white;
    }

    .demo-title {
      font-size: 18px;
      font-weight: 600;
      margin-bottom: 15px;
      text-align: center;
    }

    .demo-credentials {
      background: rgba(255, 255, 255, 0.2);
      border-radius: 10px;
      padding: 15px;
      margin-bottom: 15px;
    }

    .demo-credentials table {
      width: 100%;
      color: white;
    }

    .demo-credentials td {
      padding: 8px;
      border: none;
    }

    .btn-demo {
      background: rgba(255, 255, 255, 0.2);
      border: 1px solid rgba(255, 255, 255, 0.3);
      color: white;
      padding: 8px 16px;
      border-radius: 6px;
      font-size: 12px;
      font-weight: 500;
      cursor: pointer;
      transition: all 0.3s ease;
    }

    .btn-demo:hover {
      background: rgba(255, 255, 255, 0.3);
      color: white;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
      .auth-container {
        padding: 25px 20px;
        margin: 10px;
        max-width: 100%;
      }

      .auth-title {
        font-size: 22px;
      }

      .auth-subtitle {
        font-size: 13px;
      }

      .form-control {
        padding: 10px 12px 10px 40px;
        font-size: 13px;
      }

      .input-icon {
        left: 12px;
        font-size: 14px;
      }

      .btn-step {
        padding: 8px 20px;
        font-size: 12px;
      }

      .btn-submit {
        padding: 10px;
        font-size: 13px;
      }

      .step-buttons {
        flex-direction: column;
        gap: 8px;
      }

      .step-label {
        display: none;
      }

      .step-line {
        width: 30px;
      }

      .language_id {
        min-width: 120px;
        font-size: 12px;
        padding: 8px 12px;
      }
    }

    @media (max-width: 480px) {
      .auth-container {
        padding: 30px 20px;
        margin: 10px;
        max-width: calc(100% - 20px);
      }

      .auth-title {
        font-size: 24px;
      }

      .auth-subtitle {
        font-size: 14px;
      }

      .form-group {
        margin-bottom: 20px;
      }

      .form-control {
        padding: 14px 16px 14px 45px;
        font-size: 16px;
        min-height: 50px;
      }

      .input-icon {
        left: 15px;
        font-size: 18px;
      }

      .btn-step {
        padding: 12px 20px;
        font-size: 14px;
        min-height: 48px;
      }

      .btn-submit {
        padding: 14px;
        font-size: 16px;
        min-height: 50px;
      }

      .step-circle {
        width: 35px;
        height: 35px;
        font-size: 14px;
      }

      .auth-logo img {
        max-width: 140px;
        max-height: 70px;
      }

      .step-buttons {
        margin-top: 25px;
        gap: 10px;
      }

      .alert {
        padding: 12px 16px;
        font-size: 14px;
      }

      .language_id {
        min-width: 140px;
        font-size: 14px;
        padding: 12px 16px;
      }
    }

    /* Loading Animation */
    .loading {
      display: inline-block;
      width: 20px;
      height: 20px;
      border: 3px solid rgba(255, 255, 255, 0.3);
      border-radius: 50%;
      border-top-color: #fff;
      animation: spin 1s ease-in-out infinite;
    }

    @keyframes spin {
      to { transform: rotate(360deg); }
    }

    .error-message {
      color: #c53030;
      font-size: 12px;
      margin-top: 5px;
      display: block;
    }

    .form-group.has-error .form-control {
      border-color: #c53030;
    }
  </style>
</head>
<body>
  <!-- language -->
  <input type="hidden" id="base_url" value="<?=base_url()?>">
  <!-- language end -->

  <div class="auth-container">
    <div class="auth-header">
      <div class="auth-logo">
        <img src="<?php echo base_url(get_site_logo());?>" alt="Logo">
      </div>
      <h1 class="auth-title">Create Account</h1>
      <p class="auth-subtitle">Join us and start managing your business efficiently</p>
  </div>

    <!-- Step Progress -->
    <div class="step-progress">
      <div class="step active" data-step="1">
        <div class="step-circle">1</div>
        <div class="step-label">Personal Info</div>
      </div>
      <div class="step-line"></div>
      <div class="step" data-step="2">
        <div class="step-circle">2</div>
        <div class="step-label">Store Details</div>
      </div>
      <div class="step-line"></div>
      <div class="step" data-step="3">
        <div class="step-circle">3</div>
        <div class="step-label">Settings</div>
        </div>
      </div> 

    <!-- Alert Messages -->
    <?php if($this->session->flashdata('success')): ?>
      <div class="alert alert-success">
        <i class="fa fa-check-circle"></i> <?= $this->session->flashdata('success') ?>
        </div>
    <?php endif; ?>
         
    <?php if($this->session->flashdata('error')): ?>
      <div class="alert alert-danger">
        <i class="fa fa-exclamation-circle"></i> <?= $this->session->flashdata('error') ?>
      </div>
    <?php endif; ?>
    
    <?= form_open(base_url('login/verify'), array('method'=>'POST', 'id'=>'registration_form'));?>
      
      <!-- Step 1: Personal Information -->
      <div class="form-step active" id="step-1">
        <h3 style="margin-bottom: 25px; color: #2d3748; font-weight: 600;">Personal Information</h3>
        
        <div class="form-group">
          <input type="text" class="form-control" name="first_name" placeholder="First Name*" autofocus required>
          <i class="fa fa-user input-icon"></i>
          <small class="error-message first_name_msg" style="display: none;"></small>
        </div>
        
        <div class="form-group">
          <input type="text" class="form-control" name="last_name" placeholder="Last Name*" required>
          <i class="fa fa-user input-icon"></i>
          <small class="error-message last_name_msg" style="display: none;"></small>
        </div>

        <div class="form-group">
          <input type="email" class="form-control" placeholder="Email Address*" id="email" name="email" required>
          <i class="fa fa-envelope input-icon"></i>
          <small class="error-message email_msg" style="display: none;"></small>
        </div>
        
        <div class="form-group">
          <input type="tel" class="form-control" name="mobile" placeholder="Mobile Number*" required>
          <i class="fa fa-phone input-icon"></i>
          <small class="error-message mobile_msg" style="display: none;"></small>
        </div>

        <div class="form-group">
          <input type="password" class="form-control" placeholder="Password*" id="password" name="password" required minlength="6">
          <i class="fa fa-lock input-icon"></i>
          <small class="error-message password_msg" style="display: none;"></small>
        </div>
        
        <div class="form-group">
          <input type="password" class="form-control" placeholder="Confirm Password*" id="cpassword" name="cpassword" required>
          <i class="fa fa-lock input-icon"></i>
          <small class="error-message cpassword_msg" style="display: none;"></small>
        </div>

        <div class="step-buttons">
          <div></div>
          <button type="button" class="btn-step btn-primary" onclick="nextStep(1)">Next Step</button>
        </div>
      </div>

      <!-- Step 2: Store Details -->
      <div class="form-step" id="step-2">
        <h3 style="margin-bottom: 25px; color: #2d3748; font-weight: 600;">Store Information</h3>
        
        <div class="form-group">
          <input type="text" class="form-control" name="store_name" placeholder="Store Name*" required>
          <i class="fa fa-suitcase input-icon"></i>
          <small class="error-message store_name_msg" style="display: none;"></small>
        </div>
        
        <div class="form-group">
          <select class="form-control select2" name="country" style="width: 100%;" required>
              <option value="">Select Country*</option>
              <?=get_country_select_list()?>
            </select>
          <i class="fa fa-globe input-icon" style="top: 15px;"></i>
          <small class="error-message country_msg" style="display: none;"></small>
        </div>

        <div class="form-group">
            <select class="form-control select2" name="state" style="width: 100%;">
              <?=get_state_select_list()?>
            </select>
          <i class="fa fa-map-marker input-icon" style="top: 15px;"></i>
          <small class="error-message state_msg" style="display: none;"></small>
        </div>
        
        <div class="form-group">
          <input type="text" class="form-control" name="city" placeholder="City*" required>
          <i class="fa fa-location-arrow input-icon"></i>
          <small class="error-message city_msg" style="display: none;"></small>
        </div>

        <div class="step-buttons">
          <button type="button" class="btn-step btn-secondary" onclick="prevStep(2)">Previous</button>
          <button type="button" class="btn-step btn-primary" onclick="nextStep(2)">Next Step</button>
        </div>
      </div>

      <!-- Step 3: Settings -->
      <div class="form-step" id="step-3">
        <h3 style="margin-bottom: 25px; color: #2d3748; font-weight: 600;">System Settings</h3>
        
        <div class="form-group">
          <select class="form-control select2" id="timezone" name="timezone" style="width: 100%;" required>
            <option value="">Select Timezone*</option>
               <?php
                  $query2="select * from db_timezone where status=1";
                  $q2=$this->db->query($query2);
              if($q2->num_rows()>0) {
                foreach($q2->result() as $res1) {
                       echo "<option value='".$res1->timezone."'>".$res1->timezone."</option>";
                     }
              } else {
                echo "<option value=''>No Records Found</option>";
                  }
                  ?>
            </select>
          <i class="fa fa-clock-o input-icon" style="top: 15px;"></i>
          <small class="error-message timezone_msg" style="display: none;"></small>
        </div>

        <div class="form-group">
          <select class="form-control select2" id="date_format" name="date_format" style="width: 100%;">
               <option value="dd-mm-yyyy">dd-mm-yyyy</option>
               <option value="mm/dd/yyyy">mm/dd/yyyy</option>
            </select>
          <i class="fa fa-calendar input-icon" style="top: 15px;"></i>
          <small class="error-message date_format_msg" style="display: none;"></small>
        </div>
        
        <div class="form-group">
          <select class="form-control select2" id="time_format" name="time_format" style="width: 100%;">
               <option value="12">12 Hours</option>
              <option value="24">24 Hours</option>
            </select>
          <i class="fa fa-clock-o input-icon" style="top: 15px;"></i>
          <small class="error-message time_format_msg" style="display: none;"></small>
        </div>
        
        <div class="form-group">
          <select class="form-control select2" id="currency" name="currency" style="width: 100%;" required>
            <option value="">Select Currency*</option>
               <?php
                  $query2="select * from db_currency where status=1";
                  $q2=$this->db->query($query2);
              if($q2->num_rows()>0) {
                foreach($q2->result() as $res1) {
                       echo "<option value='".$res1->id."'>".$res1->currency_name.' '.$res1->currency_code.' ('.$res1->currency.")</option>";
                     }
              } else {
                echo "<option value=''>No Records Found</option>";
                  }
                  ?>
            </select>
          <i class="fa fa-dollar input-icon" style="top: 15px;"></i>
          <small class="error-message currency_msg" style="display: none;"></small>
        </div>
        
        <div class="form-group">
          <select class="form-control select2" id="currency_placement" name="currency_placement" style="width: 100%;" required>
              <option value="">Currency Placement*</option>
               <option value="Right">After Amount</option>
                <option value="Left">Before Amount</option>
            </select>
          <i class="fa fa-align-left input-icon" style="top: 15px;"></i>
          <small class="error-message currency_placement_msg" style="display: none;"></small>
        </div>
        
        <div class="form-group">
          <select class="form-control select2" id="decimals" name="decimals" style="width: 100%;" required>
            <option value="">Select Decimals*</option>
               <option value="1">1</option>
               <option value="2">2</option>
               <option value="3">3</option>
               <option value="4">4</option>
            </select>
          <i class="fa fa-calculator input-icon" style="top: 15px;"></i>
          <small class="error-message decimals_msg" style="display: none;"></small>
        </div>

        <div class="step-buttons">
          <button type="button" class="btn-step btn-secondary" onclick="prevStep(3)">Previous</button>
          <button type="button" class="btn-submit submit_btn" onclick="submit_form()">
            <span class="btn-text">Create Account</span>
            <span class="loading" style="display: none;"></span>
          </button>
        </div>
      </div>
    
    <?php form_close(); ?>

    <div class="auth-links">
      <a href="<?=base_url('login')?>" class="auth-link">
        <i class="fa fa-arrow-left"></i> <?= $this->lang->line('i_have_account'); ?>
      </a>
      </div>

    <!-- Language Selector -->
    <div class="language-selector">
      <?php $this->load->view('comman/language.php');?>
    </div>

    <!-- Demo Section -->
    <?php if(demo_app()): ?>
      <div class="demo-section">
        <div class="demo-title">
          <i class="fa fa-play-circle"></i> Demo Credentials
  </div>
        <div class="demo-credentials">
          <table>
            <tr>
              <td><strong>Email:</strong> admin@example.com</td>
              <td><strong>Password:</strong> 123456</td>
              <td><button type="button" class="btn-demo admin">Quick Login</button></td>
            </tr>
          </table>
     </div>
        <small><i class="fa fa-info-circle"></i> Some features are disabled in demo and will reset every hour.</small>
      </div>
    <?php endif; ?>

    <div style="text-align: center; margin-top: 20px; color: #718096; font-size: 12px;">
      Version <?=app_version();?>
    </div>
  </div>

<!-- jQuery 2.2.3 -->
<script src="<?php echo $theme_link; ?>plugins/jQuery/jquery-2.2.3.min.js"></script>
<!-- Bootstrap 3.3.6 -->
<script src="<?php echo $theme_link; ?>bootstrap/js/bootstrap.min.js"></script>
<!-- Select2 -->
<script src="<?php echo $theme_link; ?>plugins/select2/select2.full.min.js"></script>
<!--Toastr notification -->
<script src="<?php echo $theme_link; ?>toastr/toastr.js"></script>
<script src="<?php echo $theme_link; ?>toastr/toastr_custom.js"></script>
<!-- iCheck -->
<script src="<?php echo $theme_link; ?>plugins/iCheck/icheck.min.js"></script>
<script src="<?php echo $theme_link; ?>js/language.js"></script>
  
<script>
    $(document).ready(function() {
      // Initialize Select2
      $(".select2").select2();
      
      // Initialize iCheck
    $('input').iCheck({
      checkboxClass: 'icheckbox_square-blue',
      radioClass: 'iradio_square-blue',
        increaseArea: '20%'
      });

      // Setup AJAX CSRF token
      $.ajaxSetup({ 
        data: {'<?php echo $this->security->get_csrf_token_name(); ?>' : '<?php echo $this->security->get_csrf_hash(); ?>' }  
      });

      // Add focus effects to form inputs
      $('.form-control').on('focus', function() {
        $(this).parent().addClass('focused');
      }).on('blur', function() {
        if ($(this).val() === '') {
          $(this).parent().removeClass('focused');
        }
      });

      // Check if inputs have values on page load
      $('.form-control').each(function() {
        if ($(this).val() !== '') {
          $(this).parent().addClass('focused');
        }
      });

      // Password confirmation validation
      $('#cpassword').on('input', function() {
        const password = $('#password').val();
        const confirmPassword = $(this).val();
        
        if (confirmPassword && password !== confirmPassword) {
          $(this).addClass('error');
          if (!$(this).next('.error-message').length) {
            $(this).after('<small class="error-message" style="color: #c53030; font-size: 12px; margin-top: 5px; display: block;">Passwords do not match</small>');
          }
        } else {
          $(this).removeClass('error');
          $(this).next('.error-message').remove();
        }
      });

      // Demo login functionality
      $('.admin').on('click', function(e) {
        e.preventDefault();
        window.location.href = '<?=base_url()?>login';
      });
    });

    // Step navigation functions
    function nextStep(currentStep) {
      if (validateStep(currentStep)) {
        // Hide current step
        $(`#step-${currentStep}`).removeClass('active');
        $(`.step[data-step="${currentStep}"]`).removeClass('active').addClass('completed');
        
        // Show next step
        const nextStepNum = currentStep + 1;
        $(`#step-${nextStepNum}`).addClass('active');
        $(`.step[data-step="${nextStepNum}"]`).addClass('active');
      }
    }

    function prevStep(currentStep) {
      // Hide current step
      $(`#step-${currentStep}`).removeClass('active');
      $(`.step[data-step="${currentStep}"]`).removeClass('active');
      
      // Show previous step
      const prevStepNum = currentStep - 1;
      $(`#step-${prevStepNum}`).addClass('active');
      $(`.step[data-step="${prevStepNum}"]`).addClass('active');
    }

    // Validation functions
  function validateEmail(sEmail) {
      var filter = /^([\w-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([\w-]+\.)+))([a-zA-Z]{2,9}|[0-9]{1,3})(\]?)$/;
      return filter.test(sEmail);
    }

    function get_name_value(name) {
      return $(`input[name='${name}']`).val();
    }

    function get_select_value(name) {
      return $(`select[name='${name}']`).val();
    }

    function validateStep(step) {
      let isValid = true;
      
      // Clear previous error messages
      $(`.step-${step} .error-message`).hide().text('');
      $(`.step-${step} .form-group`).removeClass('has-error');

      if (step === 1) {
        // Validate personal information
        if (!get_name_value('first_name')) {
          showError('first_name_msg', 'First name is required');
          isValid = false;
        }
        
        if (!get_name_value('last_name')) {
          showError('last_name_msg', 'Last name is required');
          isValid = false;
        }
        
        if (!get_name_value('email')) {
          showError('email_msg', 'Email is required');
          isValid = false;
        } else if (!validateEmail(get_name_value('email'))) {
          showError('email_msg', 'Invalid email format');
          isValid = false;
        }
        
        if (!get_name_value('mobile')) {
          showError('mobile_msg', 'Mobile number is required');
          isValid = false;
        }
        
        if (!get_name_value('password')) {
          showError('password_msg', 'Password is required');
          isValid = false;
        } else if (get_name_value('password').length < 6) {
          showError('password_msg', 'Password must be at least 6 characters');
          isValid = false;
        }
        
        if (!get_name_value('cpassword')) {
          showError('cpassword_msg', 'Please confirm your password');
          isValid = false;
        } else if (get_name_value('password') !== get_name_value('cpassword')) {
          showError('cpassword_msg', 'Passwords do not match');
          isValid = false;
        }
      } else if (step === 2) {
        // Validate store information
        if (!get_name_value('store_name')) {
          showError('store_name_msg', 'Store name is required');
          isValid = false;
        }
        
        if (!get_select_value('country')) {
          showError('country_msg', 'Please select a country');
          isValid = false;
        }
        
        if (!get_name_value('city')) {
          showError('city_msg', 'City is required');
          isValid = false;
        }
      } else if (step === 3) {
        // Validate settings
        if (!get_select_value('timezone')) {
          showError('timezone_msg', 'Please select a timezone');
          isValid = false;
        }
        
        if (!get_select_value('currency')) {
          showError('currency_msg', 'Please select a currency');
          isValid = false;
        }
        
        if (!get_select_value('currency_placement')) {
          showError('currency_placement_msg', 'Please select currency placement');
          isValid = false;
        }
        
        if (!get_select_value('decimals')) {
          showError('decimals_msg', 'Please select decimal places');
          isValid = false;
        }
      }
      
      return isValid;
    }

    function showError(fieldName, message) {
      $(`.${fieldName}`).text(message).show();
      $(`.${fieldName}`).closest('.form-group').addClass('has-error');
    }

    // XSS validation
    function xss_validation(data) {
      if (typeof data === 'object') {
        for (var value of data.values()) {
          if (typeof value !== 'object' && (value !== '' && value.indexOf("<script>") !== -1)) {
            toastr["error"]("Failed to Continue! XSS Code found as Input!");
            return false;
          }
        }
        return true;
      } else {
        if (typeof value !== 'object' && (data !== '' && data.indexOf("<script>") !== -1)) {
          toastr["error"]("Failed to Continue! XSS Code found as Input!");
        return false;
        }
        return true;
      }
    }

    // Submit form
    function submit_form() {
      if (!validateStep(3)) {
        return false;
      }

      const data = new FormData($('#registration_form')[0]);
      
      // Check XSS Code
      if (!xss_validation(data)) {
        return false;
      }
      
      const $btn = $('.submit_btn');
      const $btnText = $btn.find('.btn-text');
      const $loading = $btn.find('.loading');
      
      // Show loading state
      $btn.prop('disabled', true);
      $btnText.hide();
      $loading.show();
      
        $.ajax({
        type: 'POST',
        url: '<?=base_url()?>register/register_store',
        data: data,
        cache: false,
        contentType: false,
        processData: false,
        success: function(result) {
          result = result.trim();
          if (result === 'success') {
            location.href = '<?=base_url()?>login';
          } else {
            toastr["error"](result);
          }          
          
          // Reset button state
          $btn.prop('disabled', false);
          $btnText.show();
          $loading.hide();
        },
        error: function() {
          toastr["error"]("An error occurred. Please try again.");
          
          // Reset button state
          $btn.prop('disabled', false);
          $btnText.show();
          $loading.hide();
        }
      });
    }
</script>
</body>
</html>
