<!DOCTYPE html>
<html>
   <head>
      <!-- TABLES CSS CODE -->
      <?php include"comman/code_css.php"; ?>
      <!-- </copy> -->  
   </head>
   <body class="hold-transition skin-blue sidebar-mini">
      <div class="wrapper">
         <?php include"sidebar.php"; ?>
         <!-- Content Wrapper. Contains page content -->
         <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
               <h1>
                  <?=$page_title;?>
                  <small></small>
               </h1>
               <ol class="breadcrumb">
                  <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i>Home</a></li>
                  <li class="active"><?=$page_title;?></li>
               </ol>
            </section>
            <!-- Main content -->
            <section class="content">
               <div class="row">
                  <!-- right column -->
                  <div class="col-md-12">
                     <!-- Horizontal Form -->
                     <div class="box box-primary ">
                        <div class="box-header with-border">
                           <h3 class="box-title">Please Enter Valid Information</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <form class="form-horizontal" id="report-form" onkeypress="return event.keyCode != 13;">
                           <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
                           <input type="hidden" id="base_url" value="<?php echo $base_url;; ?>">
                           <div class="box-body">
                              <div class="form-group">
                                 <!-- Store Code -->
                                 <?php if(store_module() && is_admin()) {$this->load->view('store/store_code',array('show_store_select_box'=>true,'store_id'=>get_current_store_id(),'div_length'=>'col-sm-3','show_all'=>'true','form_group_remove' => 'true')); }else{
                                    echo "<input type='hidden' name='store_id' id='store_id' value='".get_current_store_id()."'>";
                                    }?>
                                 <!-- Store Code end -->
                                 <label for="category_id" class="col-sm-2 control-label"><?= $this->lang->line('category_name'); ?></label>
                                 <div class="col-sm-3">
                                    <select class="form-control select2 " id="category_id" name="category_id" ">
                                       <option value="">-All-</option>
                                       <?= get_expense_category_select_list(null,get_current_store_id());?>
                                    </select>
                                    <span id="category_id_msg" style="display:none" class="text-danger"></span>
                                 </div>
                              </div>
                              <div class="form-group">
                                 <label for="from_date" class="col-sm-2 control-label"><?= $this->lang->line('from_date'); ?></label>
                                 <div class="col-sm-3">
                                    <div class="input-group date">
                                       <div class="input-group-addon">
                                          <i class="fa fa-calendar"></i>
                                       </div>
                                       <input type="text" class="form-control pull-right datepicker" id="from_date" name="from_date" value="<?php echo show_date(date('d-m-Y'));?>" >
                                    </div>
                                    <span id="from_date_msg" style="display:none" class="text-danger"></span>
                                 </div>
                                 <label for="to_date" class="col-sm-2 control-label"><?= $this->lang->line('to_date'); ?></label>
                                 <div class="col-sm-3">
                                    <div class="input-group date">
                                       <div class="input-group-addon">
                                          <i class="fa fa-calendar"></i>
                                       </div>
                                       <input type="text" class="form-control pull-right datepicker" id="to_date" name="to_date" value="<?php echo show_date(date('d-m-Y'));?>" >
                                    </div>
                                    <span id="to_date_msg" style="display:none" class="text-danger"></span>
                                 </div>
                              </div>
                           </div>
                           <!-- /.box-body -->
                           <div class="box-footer">
                              <div class="col-sm-8 col-sm-offset-2 text-center">
                                 <div class="col-sm-3">
                                    <button type="button" id="view" class=" btn btn-block btn-success" title="Save Data">Show</button>
                                 </div>
                                 <div class="col-sm-3">
                                    <button type="button" id="print_a4" class="btn btn-block btn-info" title="Print A4" style="display:none;">Print A4</button>
                                 </div>
                                 <div class="col-sm-3">
                                    <a href="<?=base_url('dashboard');?>">
                                    <button type="button" class="btn btn-block btn-warning close_btn" title="Go Dashboard">Close</button>
                                    </a>
                                 </div>
                              </div>
                           </div>
                           <!-- /.box-footer -->
                        </form>
                     </div>
                     <!-- /.box -->
                  </div>
                  <!--/.col (right) -->
               </div>
               <!-- /.row -->
            </section>
            <!-- /.content -->
            <section class="content">
               <div class="row">
                  <!-- right column -->
                  <div class="col-md-12">
                     <div class="box">
                        <div class="box-header">
                           <h3 class="box-title">Records Table</h3>
                           <?php $this->load->view('components/export_btn',array('tableId' => 'report-data'));?>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                           <thead>
                              <table class="table table-bordered table-hover  " id='report-data'>
                                 <tr class="bg-blue">
                                    <th style="">#</th>
                                    <?php if(store_module() && is_admin()){ ?>
                                    <th style=""><?= $this->lang->line('store_name'); ?></th>
                                    <?php } ?>
                                    <th style=""><?= $this->lang->line('expence_code'); ?></th>
                                    <th style=""><?= $this->lang->line('expence_date'); ?></th>
                                    <th style=""><?= $this->lang->line('category_name'); ?></th>
                                    <th style=""><?= $this->lang->line('reference_no'); ?></th>
                                    <th style=""><?= $this->lang->line('expense_for'); ?></th>
                                    <th style=""><?= $this->lang->line('amount'); ?></th>
                                    <th style=""><?= $this->lang->line('note'); ?></th>
                                    <th style=""><?= $this->lang->line('created_by'); ?></th>
                                 </tr>
                                 </thead>
                                 <tbody id="tbodyid">
                                 </tbody>
                              </table>
                        </div>
                        <!-- /.box-body -->
                     </div>
                     <!-- /.box -->
                  </div>
               </div>
            </section>
         </div>
         <!-- /.content-wrapper -->
         <?php include"footer.php"; ?>
         <!-- Add the sidebar's background. This div must be placed
            immediately after the control sidebar -->
         <div class="control-sidebar-bg"></div>
      </div>
      <!-- ./wrapper -->
      <!-- SOUND CODE -->
      <?php include"comman/code_js_sound.php"; ?>
      <!-- TABLES CODE -->
      <?php include"comman/code_js.php"; ?>
      <!-- TABLE EXPORT CODE -->
      <?php include"comman/code_js_export.php"; ?>
      <script src="<?php echo $theme_link; ?>js/sheetjs.js" type="text/javascript"></script>
      
      <script type="text/javascript">
        var base_url=$("#base_url").val();
        $("#store_id").on("change",function(){
          var store_id=$(this).val();
          $.post(base_url+"expense/get_expense_category_select_list",{store_id:store_id},function(result){
              result='<option value="">All</option>'+result;
              $("#category_id").html('').append(result).select2();
          });
        });
      </script>
      
      <script type="text/javascript">
        $("#view,#view_all").on("click",function(){
        	
        	 var base_url=$("#base_url").val();
            var from_date=document.getElementById("from_date").value;
            var to_date=document.getElementById("to_date").value;
            var category_id=document.getElementById("category_id").value;
          
        	if(from_date == "")
              {
                  toastr["warning"]("Select From Date!");
                  document.getElementById("from_date").focus();
                  return;
              }
        	 
        	 if(to_date == "")
              {
                  toastr["warning"]("Select To Date!");
                  document.getElementById("to_date").focus();
                  return;
              }
        	  
        	   if(this.id=="view_all"){
                  var view_all='yes';
                }
                else{
                  var view_all='no';
                }
        	  
                $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
                $.post(base_url+"reports/show_expense_report",{category_id:category_id,view_all:view_all,from_date:from_date,to_date:to_date,store_id:$("#store_id").val()},function(result){
                  //alert(result);
                    setTimeout(function() {
                     $("#tbodyid").empty().append(result);     
                     $(".overlay").remove();
                     $("#print_a4").show();
                     console.log("Print A4 button should be visible now");
                    }, 0);
                   }).fail(function() {
                     // Show button even if request fails
                     $(".overlay").remove();
                     $("#print_a4").show();
                     console.log("Request failed, but showing print button anyway");
                   }); 
              
        	
        });

        // Print A4 functionality
        $("#print_a4").on("click",function(){
            console.log("Print A4 button clicked");
            printExpenseReport();
        });


        function printExpenseReport() {
            var from_date = document.getElementById("from_date").value;
            var to_date = document.getElementById("to_date").value;
            var category_id = document.getElementById("category_id").value;
            var store_id = $("#store_id").val();
            
            // Get current date and time
            var currentDate = new Date();
            var dateTime = currentDate.toLocaleDateString() + ' ' + currentDate.toLocaleTimeString();
            
            // Get category name if selected
            var categoryName = "";
            if(category_id) {
                var selectedOption = $("#category_id option:selected").text();
                categoryName = selectedOption !== "-All-" ? selectedOption : "";
            }
            
            // Create print window
            var printWindow = window.open('', '_blank');
            printWindow.document.write(`
                <!DOCTYPE html>
                <html>
                <head>
                    <title>Expense Report - A4 Print</title>
                    <style>
                        @page {
                            size: A4;
                            margin: 0.5in;
                        }
                        body {
                            font-family: Arial, sans-serif;
                            font-size: 12px;
                            line-height: 1.4;
                            margin: 0;
                            padding: 10px;
                        }
                        .print-header {
                            text-align: center;
                            margin-bottom: 20px;
                            border-bottom: 2px solid #333;
                            padding-bottom: 10px;
                        }
                        .company-name {
                            font-size: 18px;
                            font-weight: bold;
                            margin-bottom: 5px;
                        }
                        .report-title {
                            font-size: 16px;
                            font-weight: bold;
                            margin-bottom: 5px;
                        }
                        .report-period {
                            font-size: 14px;
                            color: #666;
                        }
                        .print-date {
                            font-size: 10px;
                            color: #999;
                            margin-top: 5px;
                        }
                        table {
                            width: 100%;
                            border-collapse: collapse;
                            margin-top: 10px;
                        }
                        th, td {
                            border: 1px solid #333;
                            padding: 6px;
                            text-align: left;
                            font-size: 11px;
                        }
                        th {
                            background-color: #f5f5f5;
                            font-weight: bold;
                        }
                        .text-right {
                            text-align: right;
                        }
                        .text-center {
                            text-align: center;
                        }
                        .total-row {
                            font-weight: bold;
                            background-color: #f9f9f9;
                        }
                        .no-print {
                            display: none;
                        }
                    </style>
                </head>
                <body>
                    <div class="print-header">
                        <div class="company-name">${getStoreName(store_id)}</div>
                        <div class="report-title">Expense Report</div>
                        <div class="report-period">From: ${from_date} To: ${to_date}${categoryName ? ' | Category: ' + categoryName : ''}</div>
                        <div class="print-date">Generated on: ${dateTime}</div>
                    </div>
                    <div id="print-content">
                        ${document.getElementById('report-data').outerHTML}
                    </div>
                </body>
                </html>
            `);
            
            printWindow.document.close();
            printWindow.focus();
            setTimeout(function() {
                printWindow.print();
                printWindow.close();
            }, 500);
        }

        function getStoreName(storeId) {
            // This would typically make an AJAX call to get store name
            // For now, return a placeholder
            return "NCS BILLING BOOK";
        }
      </script>
      <!-- Make sidebar menu hughlighter/selector -->
      <script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>
   </body>
</html>
