<!DOCTYPE html>
<html>

<head>
<!-- FORM CSS CODE -->
<?php include"comman/code_css.php"; ?>
<!-- </copy> -->
<!-- bootstrap wysihtml5 - text editor -->
  <link rel="stylesheet" href="<?php echo $theme_link; ?>plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">
<style type="text/css">
table.table-bordered > thead > tr > th {
/* border:1px solid black;*/
text-align: center;
}
.table > tbody > tr > td, 
.table > tbody > tr > th, 
.table > tfoot > tr > td, 
.table > tfoot > tr > th, 
.table > thead > tr > td, 
.table > thead > tr > th 
{
padding-left: 2px;
padding-right: 2px;  

}

/* Removed keyboard shortcuts footer styles */

/* Currency Badge - Green Background with White Text */
.enterprise-currency-badge {
    display: inline-flex!important;
    align-items: center;
    gap: 6px;
    padding: 6px 12px;
    background: #28a745!important;
    color: #ffffff!important;
    border: none!important;
    border-radius: 6px;
    font-size: 12px;
    font-weight: 400!important;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.enterprise-currency-badge i {
    color: #ffffff!important;
    font-size: 13px;
}

/* Override any existing currency styling - Green Background with White Text */
#customer_currency_info .label-success,
#customer_currency_info .label,
#customer_currency_info_totals .label-success,
#customer_currency_info_totals .label {
    background: #28a745!important;
    color: #ffffff!important;
    border: none!important;
    border-radius: 6px;
    font-weight: 400!important;
}

/* Force green background styling for currency-related elements */
#customer_currency_info *,
#customer_currency_info_totals *,
#walkin_currency_info *,
[class*="currency"][class*="badge"],
[id*="currency"][id*="badge"],
.enterprise-currency-badge {
    background: #28a745!important;
    color: #ffffff!important;
    border: none!important;
    border-radius: 6px;
    font-weight: 400!important;
}

/* Ensure currency info displays are properly controlled by JavaScript */
#customer_currency_info {
    margin-top: 8px;
}

#customer_currency_info:not([style*="display: none"]) {
    display: inline-block;
}

/* Ensure walk-in currency info is properly styled when visible */
#walkin_currency_info {
    margin-top: 8px;
}

#walkin_currency_info:not([style*="display: none"]) {
    display: inline-block;
}

#walkin_currency_info .enterprise-currency-badge {
    display: inline-flex!important;
    align-items: center;
    gap: 6px;
    padding: 6px 12px;
    background: #28a745!important;
    color: #ffffff!important;
    border: none!important;
    border-radius: 6px;
    font-weight: 400!important;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

/* Enterprise Alert System */
.enterprise-alert {
    position: fixed;
    top: 20px;
    right: 20px;
    z-index: 9999;
    padding: 12px 20px;
    border-radius: 6px;
    font-size: 13px;
    font-weight: 600;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    max-width: 350px;
    animation: slideInRight 0.3s ease;
}

.enterprise-alert.warning {
    background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
    color: #92400e;
    border: 1px solid #f59e0b;
}

.enterprise-alert.success {
    background: linear-gradient(135deg, #d1fae5 0%, #a7f3d0 100%);
    color: #065f46;
    border: 1px solid #10b981;
}

.enterprise-alert.error {
    background: linear-gradient(135deg, #fee2e2 0%, #fecaca 100%);
    color: #991b1b;
    border: 1px solid #ef4444;
}

@keyframes slideInRight {
    from {
        transform: translateX(100%);
        opacity: 0;
    }
    to {
        transform: translateX(0);
        opacity: 1;
    }
}

/* Read-only currency fields styling */
#from_currency:disabled, #to_currency:disabled {
    background-color: #f8f9fa !important;
    color: #495057 !important;
    border-color: #ced4da !important;
    cursor: not-allowed !important;
    opacity: 0.8 !important;
}

</style>
</head>


<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
 
 
 <?php include"sidebar.php"; ?>
 
 <?php
    if(isset($sales_id)){

      //Edit
      $q2 = $this->db->query("select * from db_sales where id=$sales_id");
      $customer_id=$q2->row()->customer_id;
      $sales_date=show_date($q2->row()->sales_date);
      $due_date=(!empty($q2->row()->due_date)) ? show_date($q2->row()->due_date) : '';
      $sales_status=$q2->row()->sales_status;
      $warehouse_id=$q2->row()->warehouse_id;
      $reference_no=$q2->row()->reference_no;
      $discount_input=store_number_format($q2->row()->discount_to_all_input,0);
      $discount_type=$q2->row()->discount_to_all_type;
      $other_charges_input=store_number_format($q2->row()->other_charges_input,0);
      $other_charges_tax_id=$q2->row()->other_charges_tax_id;
      $sales_note=$q2->row()->sales_note;
      $store_id=$q2->row()->store_id;
      
      $init_code=$q2->row()->init_code;
      $count_id=$q2->row()->count_id;

      $coupon_id=$q2->row()->coupon_id;
      $coupon_code = (!empty($coupon_id)) ? get_customer_coupon_details($coupon_id)->code : '';
      $invoice_terms=$q2->row()->invoice_terms;


      $items_count = $this->db->query("select count(*) as items_count from db_salesitems where sales_id=$sales_id")->row()->items_count;
      $save_operation = false;
    }
    else if(isset($quotation_id) && !empty($quotation_id)){
      //NEW
      $q2 = $this->db->query("select * from db_quotation where id=$quotation_id");
      $customer_id=$q2->row()->customer_id;
      $sales_date=show_date($q2->row()->quotation_date);
      $due_date='';
      $sales_status='';
      $warehouse_id=$q2->row()->warehouse_id;
      $reference_no=$q2->row()->reference_no;
      $discount_input=store_number_format($q2->row()->discount_to_all_input,0);
      $discount_type=$q2->row()->discount_to_all_type;
      $other_charges_input=store_number_format($q2->row()->other_charges_input,0);
      $other_charges_tax_id=$q2->row()->other_charges_tax_id;
      $sales_note=$q2->row()->quotation_note;
      $store_id=$q2->row()->store_id;

      //$sales_code = get_init_code('sales');
      $init_code=get_only_init_code('sales');
      $count_id=get_last_count_id('db_sales');

      $items_count = $this->db->query("select count(*) as items_count from db_quotationitems where quotation_id=$quotation_id")->row()->items_count;
      $coupon_code='';

      $store_details = get_store_details($store_id);
      $invoice_terms =$store_details->invoice_terms;
      $save_operation = true;
    }
    else{
      //NEW
      $customer_id  = $sales_date = $sales_status = $warehouse_id =$due_date=
      $reference_no  =$coupon_code=
      $other_charges_input          = $other_charges_tax_id = $store_id =
      $discount_type  = $sales_note = '';
      $sales_date=show_date(date("d-m-Y"));
      $discount_input = $this->db->select("sales_discount")->get('db_store')->row()->sales_discount;
      $discount_input = ($discount_input==0) ? 0 : $discount_input;
      
      $init_code=get_only_init_code('sales');
      $count_id=get_last_count_id('db_sales');

      $store_details = get_store_details();
      $invoice_terms =$store_details->invoice_terms;
      $save_operation = true;
    }
   
   
    ?>

 

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- **********************MODALS***************** -->
    <?php include"modals/modal_customer.php"; ?>
    <?php include"modals/modal_item.php"; ?>
    <?php include"modals/modal_item_or_service.php"; ?>
    <?php include"modals/modal_sales_batch_selection.php"; ?>
   <?php /*include"modals/modal_service.php";*/ ?>
    <!-- **********************MODALS END***************** -->
    <!-- Content Header (Page header) -->
    <section class="content-header">
         <h1>
            <?=$page_title;?>
            <small>Add/Update Sales</small>
         </h1>
         <ol class="breadcrumb">
            <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo $base_url; ?>sales"><?= $this->lang->line('sales_list'); ?></a></li>
            <li><a href="<?php echo $base_url; ?>sales/add"><?= $this->lang->line('new_sales'); ?></a></li>
            <li class="active"><?=$page_title;?></li>
         </ol>
      </section>

    <!-- Main content -->
     <section class="content">
               <div class="row">
                <!-- ********** ALERT MESSAGE START******* -->
               <?php include"comman/code_flashdata.php"; ?>
               <?php include"modals/modal_sales_item.php"; ?>
               
               <!-- ********** ALERT MESSAGE END******* -->
                  <!-- right column -->
                  <div class="col-md-12">
                     <!-- Horizontal Form -->
                     <div class="box box-primary " >
                        <!-- style="background: #68deac;" -->
                        
                        <!-- form start -->
                         <!-- OK START -->
                        <?= form_open('#', array('class' => 'form-horizontal', 'id' => 'sales-form', 'enctype'=>'multipart/form-data', 'method'=>'POST'));?>
                           <input type="hidden" id="base_url" value="<?php echo $base_url;; ?>">
                           <input type="hidden" value='1' id="hidden_rowcount" name="hidden_rowcount">
                           <input type="hidden" value='0' id="hidden_update_rowid" name="hidden_update_rowid">
                           <input type="hidden" value='Final' id="sales_status" name="sales_status">

                          <?php if(isset($quotation_id)) {?>
                           <input type="hidden" id="quotation_id" name="quotation_id" value="<?php echo $quotation_id;; ?>">
                           <?php } ?>

                           <div class="box-body">
                              <!-- Store Code -->
                              <?php 
                              /*if(store_module() && is_admin()) {$this->load->view('store/store_code',array('show_store_select_box'=>true,'store_id'=>$store_id,'div_length'=>'col-sm-3')); }else{*/
                                echo "<input type='hidden' name='store_id' id='store_id' value='".get_current_store_id()."'>";
                              /*}*/
                              ?>
                              <!-- Store Code end -->
                              <!-- Warehouse Code -->
                              
                              <!-- Warehouse Code end -->
                              <div class="form-group">
                                 <label for="warehouse_id" class="col-sm-2 control-label"><?= $this->lang->line('warehouse'); ?><label class="text-danger">*</label></label>
                                 <div class="col-sm-3">
                                    <select class="form-control select2 " id="warehouse_id" name="warehouse_id" >
                                       <?= get_warehouse_select_list($warehouse_id,get_current_store_id());?>
                                    </select>
                                    <span id="warehouse_id_msg" style="display:none" class="text-danger"></span>
                                 </div>
                                 <label for="init_code" class="col-sm-2 control-label"><?= $this->lang->line('sales_code'); ?><label class="text-danger">*</label></label>
                                 <div class="col-sm-2" style="padding-right:0;">
                                    <input type="text" value="<?= $init_code; ?>" class="form-control  no-padding" style='font-size:20px;' id="init_code" name="init_code" placeholder="" >
                                       <span id="init_code_msg" style="display:none" class="text-danger"></span>
                                 </div>
                                 <div class="col-sm-1" style="padding-left:1;">
                                    <input type="text" style='font-size:20px;' value="<?php echo  $count_id; ?>" class="form-control no_special_char" id="count_id" name="count_id" placeholder="" >
                                       <span id="count_id_msg" style="display:none" class="text-danger"></span>
                                 </div>

                                 
                            <!-- <div class="col-sm-2">
                                <div class="checkbox">
                                    <label toggle='tooltip' title="Check for Non GST Bill Creation">
                                        <input type="checkbox" name="" checked="" />
                                        <span></span>
                                        Non GST
                                    </label>
                                </div>
                            </div> -->


                                 
                              </div>
                              <div class="form-group">
                                 <label for="customer_id" class="col-sm-2 control-label"><?= $this->lang->line('customer_name'); ?><label class="text-danger">*</label></label>
                                 <div class="col-sm-3">
                                    <div class="input-group">
                                       <select class="form-control select2" id="customer_id" name="customer_id"  style="width: 100%;">
                                       </select>
                                       <span class="input-group-addon pointer" data-toggle="modal" data-target="#customer-modal" title="New Customer?"><i class="fa fa-user-plus text-primary fa-lg"></i></span>
                                    </div>
                                    <span id="customer_id_msg" style="display:none" class="text-danger"></span>
                                    <lable><?= $this->lang->line('previous_due'); ?> :<label class="customer_previous_due text-red" style="font-size: 18px;">0.00</label></lable>
                                    <br>
                                    <!-- Customer Type Display -->
                                    <div id="customer_type_info" style="display: none; margin-top: 5px;">
                                        <span class="label label-info" id="customer_type_label">
                                            <i class="fa fa-tag"></i> <span id="customer_type_text"></span>
                                        </span>
                                    </div>
                                    <div id="customer_currency_info" style="display: none; margin-top: 8px;">
                                        <span class="enterprise-currency-badge">
                                            <i class="fa fa-money"></i> <span id="customer_currency_name"></span>
                                        </span>
                                    </div>
                                    <!-- Walk-in Customer Currency Display -->
                                    <div id="walkin_currency_info" style="display: none; margin-top: 8px;">
                                        <span class="enterprise-currency-badge">
                                            <i class="fa fa-user"></i> <span id="walkin_currency_name"></span>
                                        </span>
                                    </div>
                                 </div>
                                 <label for="sales_date" class="col-sm-2 control-label"><?= $this->lang->line('sales_date'); ?> <label class="text-danger">*</label></label>
                                 <div class="col-sm-3">
                                    <div class="input-group date">
                                       <div class="input-group-addon">
                                          <i class="fa fa-calendar"></i>
                                       </div>
                                       <input type="text" class="form-control pull-right datepicker"  id="sales_date" name="sales_date" readonly onkeyup="shift_cursor(event,'sales_status')" value="<?= $sales_date;?>">
                                    </div>
                                    <span id="sales_date_msg" style="display:none" class="text-danger"></span>
                                 </div>
                              </div>
                              <div class="form-group">
                                 <label for="reference_no" class="col-sm-2 control-label"><?= $this->lang->line('reference_no'); ?> </label>
                                 <div class="col-sm-3">
                                    <input type="text" value="<?php echo  $reference_no; ?>" class="form-control " id="reference_no" name="reference_no" placeholder="" >
                  <span id="reference_no_msg" style="display:none" class="text-danger"></span>
                                 </div>
                                <label for="due_date" class="col-sm-2 control-label"><?= $this->lang->line('due_date'); ?></label>
                                 <div class="col-sm-3">
                                    <div class="input-group date">
                                       <div class="input-group-addon">
                                          <i class="fa fa-calendar"></i>
                                       </div>
                                       <input type="text" class="form-control pull-right datepicker"  id="due_date" name="due_date"  value="<?= $due_date;?>">
                                    </div>
                                    <span id="due_date_msg" style="display:none" class="text-danger"></span>
                                 </div>
                              </div>
                              
                           </div>
                           <!-- /.box-body -->
                           
                           <div class="row">
                              <div class="col-md-12">
                                <div class="col-md-12">
                                  <div class="box">
                                    <div class="box-info">
                                      <div class="box-header">
                                        <div class="col-md-8 col-md-offset-2 d-flex justify-content" >
                                          <div class="input-group">
                                                <span class="input-group-addon" title="Select Items"><i class="fa fa-barcode"></i></span>
                                                 <input type="text" class="form-control " placeholder="Item name/Barcode/Itemcode" autofocus id="item_search">


                                                 <span class="input-group-addon pointer text-green show_item_service" title="Click to Add New Item or Service"><i class="fa fa-plus"></i></span>

                                                 


                                              </div>
                                        </div>
                                      </div>
                                      <div class="box-body">
                                        <div class="table-responsive" style="width: 100%">
                                        <table class="table table-hover table-bordered" style="width:100%" id="sales_table">
                                             <thead class="custom_thead">
                                                <tr class="bg-primary" >
                                                   <th rowspan='2' style="width:15%"><?= $this->lang->line('item_name'); ?></th>
                                                 
                                                   <th rowspan='2' style="width:10%;min-width: 180px;"><?= $this->lang->line('quantity'); ?></th>
                                                   <th rowspan='2' style="width:10%"><?= $this->lang->line('unit_price'); ?></th> 
                                                   <th rowspan='2' style="width:10%"><?= $this->lang->line('discount'); ?>(<span id="discount_currency_symbol" class="currency_symbol">$</span>)</th>
                                                   <th rowspan='2' style="width:10%"><?= $this->lang->line('tax_amount'); ?></th>
                                                   <th rowspan='2' style="width:5%"><?= $this->lang->line('tax'); ?></th>
                                                   <th rowspan='2' style="width:7.5%"><?= $this->lang->line('total_amount'); ?></th>
                                                   <th rowspan='2' style="width:7.5%"><?= $this->lang->line('action'); ?></th>
                                                </tr>
                                             </thead>
                                             <tbody>
                                               
                                             </tbody>
                                          </table>
                                      </div>
                                      </div>
                                    </div>
                                  </div>
                                  

                                </div>
                              </div>
                              
                              <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-12">
                                       <div class="form-group">
                                          <label for="" class="col-sm-4 control-label"><?= $this->lang->line('quantity'); ?></label>    
                                          <div class="col-sm-4">
                                             <label class="control-label total_quantity text-success" style="font-size: 15pt;">0</label>
                                          </div>
                                       </div>
                                    </div>
                                 </div>

                                 

                                 <div class="row">
                                    <div class="col-md-12">
                                       <div class="form-group">
                                          <label for="other_charges_input" class="col-sm-4 control-label"><?= $this->lang->line('other_charges'); ?></label>    
                                          <div class="col-sm-4">
                                             <input type="text" class="form-control text-right only_currency" id="other_charges_input" name="other_charges_input" onkeyup="final_total();" value="<?php echo  $other_charges_input; ?>">
                                          </div>
                                          <div class="col-sm-4">
                                             <select class="form-control " id="other_charges_tax_id" name="other_charges_tax_id" onchange="final_total();" style="width: 100%;">
                                                <?= get_tax_select_list($other_charges_tax_id,get_current_store_id());?>
                                             </select>
                                          </div>
                                       </div>
                                    </div>
                                 </div>
                                 <div class="row">
                                    <div class="col-md-12">
                                       <div class="form-group">
                                          <label for="other_charges_input" class="col-sm-4 control-label"><?= $this->lang->line('discountCouponCode'); ?></label>    
                                          <div class="col-sm-8">
                                             <input type="text" class="form-control" id="coupon_code" name="coupon_code" value="<?=$coupon_code; ?>">

                                             <label class="control-label pull-left"><?= $this->lang->line('couponType'); ?>:<span class="coupon_type">---</span></label>
                                             <label class="control-label pull-right"><?= $this->lang->line('couponValue'); ?>:<span class="coupon_value">0.00</span></label>
                                          </div>
                                       </div>
                                    </div>
                                    <div class="col-md-12 div1 hide">
                                       <div class="form-group">    
                                          <div class="col-sm-8 col-sm-offset-4">
                                             <div class="alert text-left msg_color">
                                              <strong id="coupon_code_msg">
                                              </strong>
                                            </div>
                                          </div>
                                       </div>
                                    </div>

                                 </div>

                                 
                                 <div class="row">
                                    <div class="col-md-12">
                                       <div class="form-group">
                                          <label for="discount_to_all_input" class="col-sm-4 control-label"><?= $this->lang->line('discount_on_all'); ?></label>    
                                          <div class="col-sm-4">
                                             <input type="text" class="form-control  text-right only_currency" id="discount_to_all_input" name="discount_to_all_input" onkeyup="enable_or_disable_item_discount();" value="<?= store_number_format($discount_input,0); ?>">
                                          </div>
                                          <div class="col-sm-4">
                                             <select class="form-control" onchange="final_total();" id='discount_to_all_type' name="discount_to_all_type">
                                                <option value='in_percentage'>Per%</option>
                                                <option value='in_fixed'>Fixed</option>
                                             </select>
                                          </div>
                                          <!-- Dynamicaly select Supplier name -->
                                          <script type="text/javascript">
                                             <?php if($discount_type!=''){ ?>
                                                 document.getElementById('discount_to_all_type').value='<?php echo  $discount_type; ?>';
                                             <?php }?>
                                          </script>
                                          <!-- Dynamicaly select Supplier name end-->
                                       </div>
                                    </div>
                                 </div>
                                <div class="row">
                                    <div class="col-md-12">
                                       <div class="form-group">
                                          <label for="sales_note" class="col-sm-4 control-label"><?= $this->lang->line('note'); ?></label>    
                                          <div class="col-sm-8">
                                             <textarea class="form-control text-left" id='sales_note' name="sales_note"><?= $sales_note; ?></textarea>
                                            <span id="sales_note_msg" style="display:none" class="text-danger"></span>
                                          </div>
                                       </div>
                                    </div>
                                 </div>

                                 
                              </div>
                              

                              <div class="col-md-6">
                                 <div class="row">
                                    <div class="col-md-12">
                                       <div class="form-group">
                                           
                                          <table  class="col-md-9">
                                             <tr>
                                                <th class="text-right" style="font-size: 17px;"><?= $this->lang->line('subtotal'); ?></th>
                                                <th class="text-right" style="padding-left:10%;font-size: 17px;">
                                                   <h4><b><span class="currency_symbol">$</span> <span id="subtotal_amt" name="subtotal_amt">0.00</span></b></h4>
                                                </th>
                                             </tr>
                                             <tr>
                                                <th class="text-right" style="font-size: 17px;"><?= $this->lang->line('other_charges'); ?></th>
                                                <th class="text-right" style="padding-left:10%;font-size: 17px;">
                                                   <h4><b><span class="currency_symbol">$</span> <span id="other_charges_amt" name="other_charges_amt">0.00</span></b></h4>
                                                </th>
                                             </tr>
                                             <tr>
                                                <th class="text-right" style="font-size: 17px;"><?= $this->lang->line('couponDiscount'); ?></th>
                                                <th class="text-right" style="padding-left:10%;font-size: 17px;">
                                                   <h4><b><span class="currency_symbol">$</span> <span id="coupon_discount_amt" name="coupon_discount_amt">0.00</span></b></h4>
                                                </th>
                                             </tr>
                                             <tr>
                                                <th class="text-right" style="font-size: 17px;"><?= $this->lang->line('discount_on_all'); ?></th>
                                                <th class="text-right" style="padding-left:10%;font-size: 17px;">
                                                   <h4><b><span class="currency_symbol">$</span> <span id="discount_to_all_amt" name="discount_to_all_amt">0.00</span></b></h4>
                                                </th>
                                             </tr>
                                             <tr style="<?= (!is_enabled_round_off()) ? 'display: none;' : '';?>">
                                                <th class="text-right" style="font-size: 17px;"><?= $this->lang->line('round_off'); ?>
                                                <i class="hover-q " data-container="body" data-toggle="popover" data-placement="top" data-content="Go to Site Settings-> Site -> Disable the Round Off(Checkbox)." data-html="true" data-trigger="hover" data-original-title="" title="Do you wants to Disable Round Off ?">
                                                      <i class="fa fa-info-circle text-maroon text-black hover-q"></i>
                                                    </i>
                                                  
                                                </th>
                                                <th class="text-right" style="padding-left:10%;font-size: 17px;">
                                                   <h4><b><span class="currency_symbol">$</span> <span id="round_off_amt" name="tot_round_off_amt">0.00</span></b></h4>
                                                </th>
                                             </tr>
                                             <tr>
                                                <th class="text-right" style="font-size: 17px;"><?= $this->lang->line('grand_total'); ?></th>
                                                <th class="text-right" style="padding-left:10%;font-size: 17px;">
                                                   <h4><b><span class="currency_symbol">$</span> <span id="total_amt" name="total_amt">0.00</span></b></h4>
                                                </th>
                                             </tr>
                                          </table>
                                       </div>
                                    </div>
                                 </div>
                              </div>

                              <div class="col-xs-12 ">
                                 <div class="col-sm-12">
                                       <div class="box-body ">
                                        <div class="col-md-12">
                                          <table class="table table-hover table-bordered" style="width:100%" id="payments_table"><h4 class="box-title text-info"><?= $this->lang->line('previous_payments_information'); ?> : </h4>
                                             <thead>
                                                <tr class="bg-gray " >
                                                   <th>#</th>
                                                   <th><?= $this->lang->line('date'); ?></th>
                                                   <th><?= $this->lang->line('payment_type'); ?></th>
                                                   <th><?= $this->lang->line('payment_note'); ?></th>
                                                   <th><?= $this->lang->line('payment'); ?></th>
                                                   <th><?= $this->lang->line('action'); ?></th>
                                                </tr>
                                             </thead>
                                             <tbody>
                                                <?php 
                                                  if(isset($sales_id)){
                                                    $q3 = $this->db->query("select * from db_salespayments where sales_id=$sales_id");
                                                    if($q3->num_rows()>0){
                                                      $i=1;
                                                      $total_paid = 0;
                                                      foreach ($q3->result() as $res3) {
                                                        echo "<tr class='text-center text-bold' id='payment_row_".$res3->id."'>";
                                                        echo "<td>".$i."</td>";
                                                        echo "<td>".show_date($res3->payment_date)."</td>";
                                                        echo "<td>".$res3->payment_type."</td>";
                                                        echo "<td>".$res3->payment_note."</td>";
                                                        echo "<td class='text-right' id='paid_amt_$i'>".store_number_format($res3->payment)."</td>";
                                                        echo '<td><i class="fa fa-trash text-red pointer" onclick="delete_payment('.$res3->id.')"> Delete</i></td>';
                                                        echo "</tr>";
                                                        $total_paid +=$res3->payment;
                                                        $i++;
                                                      }
                                                      echo "<tr class='text-right text-bold'><td colspan='4' >Total</td><td data-rowcount='$i' id='paid_amt_tot'>".store_number_format($total_paid)."</td><td></td></tr>";
                                                    }
                                                    else{
                                                      echo "<tr><td colspan='6' class='text-center text-bold'>No Previous Payments Found!!</td></tr>";
                                                    }

                                                  }
                                                  else{
                                                    echo "<tr><td colspan='6' class='text-center text-bold'>Payments Pending!!</td></tr>";
                                                  }
                                                ?>
                                             </tbody>
                                          </table>
                                        </div>
                                       </div>
                                       <!-- /.box-body -->
                                    </div>
                                 <!-- /.box -->
                              </div>


                              <div class="col-xs-12 ">

                                 <div class="col-sm-12">



                                    <div class="col-md-12">
                                       
                                       <!-- /.box-header -->
                                       <div class="box-body">
                                         

                                         <div class="box box-default collapsed-box">
                                       <div class="box-header with-border">
                                         <h3 class="box-title"><?= $this->lang->line('invoiceTermsAndConditions')?></h3>

                                         <div class="box-tools pull-right">
                                           <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus text-danger"></i>
                                           </button>
                                       </div>
                                    </div>
                                       <!-- /.box-header -->
                                       <div class="box-body">
                                        <textarea id="invoice_terms" name="invoice_terms" class="textarea" placeholder="Place some text here" style="width: 100%; height: 100px; font-size: 14px; border: 1px solid #dddddd; padding: 10px;"><?= $invoice_terms;?></textarea>
                                       </div>
                                       <!-- /.box-body -->
                                      
                                     </div>

                                       </div>
                                       <!-- /.box-body -->
                                    
                                     <!-- /.box -->
                                   </div>



                                       <div class="box-body ">

                                          <div class="col-md-12 payments_div payments_div_">
                                            <h4 class="box-title text-info"><?= $this->lang->line('payment'); ?> : </h4>

                                            <div class="row">
                                                 <div class="col-md-4">

                                                  <span for="">
                                                    <label>
                                                    <?= $this->lang->line('advance'); ?> : <label class='customer_tot_advance'></label>
                                                  </label>
                                                  </span>
                                                  
                                                  <div class="checkbox">
                                                    <label>
                                                      <input type="checkbox" id="allow_tot_advance" name="allow_tot_advance"> <?= $this->lang->line('adjust_advance_payment'); ?>
                                                    </label>
                                                  </div>
                                                 </div>
                                                  
                                              <div class="clearfix"></div>
                                          </div>
                                          <br>

                                          <div class="box box-solid bg-gray">
                                            <div class="box-body">
                                               
                                              <div class="row">
                                         
                                                <div class="col-md-4">
                                                  <div class="">
                                                  <label for="amount"><?= $this->lang->line('amount'); ?></label>
                                                    <input type="text" class="form-control text-right paid_amt only_currency" id="amount" name="amount" placeholder="" >
                                                      <span id="amount_msg" style="display:none" class="text-danger"></span>
                                                </div>
                                               </div>
                                                <div class="col-md-4">
                                                  <div class="">
                                                    <label for="payment_type"><?= $this->lang->line('payment_type'); ?></label>
                                                    <select class="form-control select2" id='payment_type' name="payment_type">
                                                      <?php
                                                        $q1=$this->db->query("select * from db_paymenttypes where status=1 and store_id=".get_current_store_id());
                                                         if($q1->num_rows()>0){
                                                            echo "<option value=''>-Select-</option>";
                                                             foreach($q1->result() as $res1){
                                                             echo "<option value='".$res1->payment_type."'>".$res1->payment_type ."</option>";
                                                           }
                                                         }
                                                         else{
                                                            echo "<option value=''>None</option>";
                                                         }
                                                        ?>
                                                    </select>
                                                    <span id="payment_type_msg" style="display:none" class="text-danger"></span>
                                                  </div>
                                                </div>
                                                
                                                <div class="col-md-4">
                                                  <div class="">
                                                    <label for="payment_currency">Payment Currency</label>
                                                    <select class="form-control select2" id='payment_currency' name="payment_currency" onchange="update_payment_currency_sales(); validateAccountCurrency(); checkPaymentCurrencyExchangeRate(); autoSelectCurrencyAccount();">
                                                      <?php
                                                        $base_currency = get_base_currency();
                                                        $customer_currency = null;
                                                        
                                                        // Get customer currency if available
                                                        if (isset($customer_id) && !empty($customer_id)) {
                                                            $customer_currency = get_customer_trading_currency($customer_id);
                                                        }
                                                        
                                                        // Customer trading currency option (if different from base) - DEFAULT
                                                        if ($customer_currency && $customer_currency->id != $base_currency->id) {
                                                            echo "<option value='".$customer_currency->id."' selected>".$customer_currency->currency_name." (".$customer_currency->currency_code.") - Customer Currency</option>";
                                                        }
                                                        
                                                        // Base currency option
                                                        echo "<option value='".$base_currency->id."' ".($customer_currency && $customer_currency->id != $base_currency->id ? '' : 'selected').">".$base_currency->currency_name." (".$base_currency->currency_code.") - Base Currency</option>";
                                                      ?>
                                                    </select>
                                                    <span id="payment_currency_msg" style="display:none" class="text-danger"></span>
                                                  </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <label for="account_id"><?= $this->lang->line('account'); ?></label>
                                                    <select class="form-control select2" id='account_id' name="account_id" onchange="validateAccountCurrency()">
                                                      <option value="">-Select Currency First-</option>
                                                    </select>
                                                    <span id="account_id_msg" style="display:none" class="text-danger"></span>
                                                    <div id="account_currency_alert" class="alert alert-warning" style="display:none; margin-top: 5px;">
                                                       <i class="fa fa-exclamation-triangle"></i> <strong>Warning:</strong> Selected account currency doesn't match payment currency. Consider selecting a matching currency account.
                                                    </div>
                                                </div>
                                            <div class="clearfix"></div>
                                        </div> 

                                        <div class="row cheque_div" style="display: none;">
                                         
                                                <div class="col-md-8">
                                                  <div class="">
                                                  <label for="cheque_number"><?= $this->lang->line('cheque_number'); ?></label>
                                                    <input type="text" class="form-control" id="cheque_number" name="cheque_number" placeholder="" >
                                                      <span id="cheque_number_msg" style="display:none" class="text-danger"></span>
                                                </div>
                                               </div>
                                                
                                               <div class="col-md-4">
                                                  <div class="">
                                                  <label for="cheque_period"><?= $this->lang->line('cheque_period_days'); ?></label>
                                                    <input type="text" class="form-control only_currency" id="cheque_period" name="cheque_period" placeholder="" >
                                                      <span id="cheque_period_msg" style="display:none" class="text-danger"></span>
                                                </div>
                                               </div>

                                            <div class="clearfix"></div>
                                        </div> 

                                        <div class="row">
                                               <div class="col-md-12">
                                                  <div class="">
                                                    <label for="payment_note"><?= $this->lang->line('payment_note'); ?></label>
                                                    <textarea type="text" class="form-control" id="payment_note" name="payment_note" placeholder="" ></textarea>
                                                    <span id="payment_note_msg" style="display:none" class="text-danger"></span>
                                                  </div>
                                               </div>
                                                
                                            <div class="clearfix"></div>
                                        </div>   
                                        </div>
                                        </div>
                                        </div><!-- col-md-12 -->
                                       </div>
                                       <!-- /.box-body -->
                                    </div>
                                 <!-- /.box -->
                              </div>

                              <!-- SMS Sender while saving -->
                                <?php 
                                   //Change Return
                                    $send_sms_checkbox='disabled';
                                    if($CI->is_sms_enabled()){
                                      if(!isset($sales_id)){
                                        $send_sms_checkbox='checked';  
                                      }else{
                                        $send_sms_checkbox='';
                                      }
                                    }

                              ?>
                             
                              <div class="col-xs-12 ">
                                 <div class="col-sm-12">
                                       <div class="box-body ">
                                          <div class="col-md-12">
                                            <div class="checkbox icheck">
                                      <label>
                                        <input type="checkbox" <?=$send_sms_checkbox;?> class="form-control" id="send_sms" name="send_sms" > <label for="sales_discount" class=" control-label"><?= $this->lang->line('send_sms_to_customer'); ?>
                                          <i class="hover-q " data-container="body" data-toggle="popover" data-placement="top" data-content="If checkbox is Disabled! You need to enable it from SMS -> SMS API <br><b>Note:<i>Walk-in Customer will not receive SMS!</i></b>" data-html="true" data-trigger="hover" data-original-title="" title="Do you wants to send SMS ?">
                                  <i class="fa fa-info-circle text-maroon text-black hover-q"></i>
                                </i>
                                        </label>
                                      </label>
                                    </div>
                                        </div><!-- col-md-12 -->
                                       </div>
                                       <!-- /.box-body -->
                                    </div>
                                 <!-- /.box -->
                              </div> 
                           </div>
                           
                           <!-- /.box-body -->
                           <div class="box-footer col-sm-12">
                              <center>
                                <?php
                                if(isset($sales_id)){
                                  $btn_id='update';
                                  $btn_name="Update";
                                  echo '<input type="hidden" name="sales_id" id="sales_id" value="'.$sales_id.'"/>';
                                }
                                else{
                                  $btn_id='save';
                                  $btn_name="Save";
                                }

                                ?>
                                 <div class="col-md-3 col-md-offset-3">
                                    <button type="button" id="<?php echo $btn_id;?>" class="btn btn-block btn-success payments_modal" title="Save Data"><?php echo $btn_name;?></button>
                                 </div>
                                 <div class="col-sm-3"><a href="<?= base_url()?>dashboard">
                                    <button type="button" class="btn btn-block btn-warning" title="Go Dashboard">Close</button>
                                  </a>
                                </div>
                              </center>
                           </div>
                           

                           <?= form_close(); ?>
                           <!-- OK END -->
                     </div>
                  </div>
                  <!-- /.box-footer -->
                 
               </div>
               <!-- /.box -->
             </section>
            <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
 <?php include"footer.php"; ?>
<!-- SOUND CODE -->
<?php include"comman/code_js_sound.php"; ?>
<!-- GENERAL CODE -->
<?php include"comman/code_js.php"; ?>

<script src="<?php echo $theme_link; ?>js/modals.js"></script>
<script src="<?php echo $theme_link; ?>js/modals/modal_item.js"></script>
         <!-- Add the sidebar's background. This div must be placed
            immediately after the control sidebar -->
         <div class="control-sidebar-bg"></div>
      </div>
      <!-- ./wrapper -->

      <!-- Exchange Rate Modal -->
      <div class="modal fade" id="exchangeRateModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content">
            <div class="modal-header bg-warning">
              <h4 class="modal-title">
                <i class="fa fa-exclamation-triangle"></i> Add Exchange Rate
              </h4>
            </div>
            <div class="modal-body">
              <div class="alert alert-warning">
                <strong>Exchange Rate Missing!</strong> Please add the exchange rate for this currency conversion to proceed.
              </div>
              
              <!-- Rate Source Selection -->
              <div class="form-group">
                <label>Rate Source</label>
                <div class="radio">
                  <label>
                    <input type="radio" name="rate_source" value="manual" checked> Manual Entry
                  </label>
                </div>
                <div class="radio">
                  <label>
                    <input type="radio" name="rate_source" value="api"> Fetch from API
                  </label>
                </div>
              </div>
              
              <form id="exchangeRateForm">
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group">
                      <label for="from_currency">From Currency (Customer Currency)</label>
                      <select class="form-control" id="from_currency" name="from_currency" required readonly disabled>
                        <option value="">Select Customer Currency</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label for="to_currency">To Currency (System Currency)</label>
                      <select class="form-control" id="to_currency" name="to_currency" required readonly disabled>
                        <option value="">Select System Currency</option>
                      </select>
                    </div>
                  </div>
                </div>
                
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-group">
                      <label for="exchange_rate">Exchange Rate</label>
                      <input type="number" class="form-control" id="exchange_rate" name="exchange_rate" 
                             step="0.000001" min="0" placeholder="Enter exchange rate" required>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label for="rate_date">Rate Date</label>
                      <input type="date" class="form-control" id="rate_date" name="rate_date" 
                             value="<?= date('Y-m-d') ?>" required>
                    </div>
                  </div>
                </div>
                
                <div class="form-group">
                  <label for="rate_note">Notes (Optional)</label>
                  <textarea class="form-control" id="rate_note" name="rate_note" rows="2" 
                            placeholder="Add any notes about this exchange rate"></textarea>
                </div>
              </form>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
              <button type="button" class="btn btn-warning" id="saveExchangeRate">
                <i class="fa fa-save"></i> Save Exchange Rate
              </button>
            </div>
          </div>
        </div>
      </div>
<script type="text/javascript">
  var walk_in_customer_name ='<?= get_walk_in_customer_name();?>'
</script>
<!-- Bootstrap WYSIHTML5 -->
<script src="<?php echo $theme_link; ?>plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>

<script src="<?php echo $theme_link; ?>js/sales.js"></script>  
<script src="<?php echo $theme_link; ?>js/ajaxselect/customer_select_ajax.js"></script>  
      <script>

         //Customer Selection Box Search
         function getCustomerSelectionId() {
           return '#customer_id';
         }

         $(document).ready(function () {

            var customer_id = "<?= (!empty($customer_id)) ? $customer_id : '';  ?>";

            autoLoadFirstCustomer(customer_id);
            
            // Initialize account dropdown based on default currency
            initializeAccountDropdown();
            
            // Show customer currency on page load
            show_customer_currency();

         });
         //Customer Selection Box Search - END
         


         function save_operation() {
            <?php if($save_operation){ ?>
               return true;
            <?php }else{ ?>
               return false;
            <?php } ?>
         }

         $("#payment_type").on("change",function(){
          show_cheque_details();
        });
        function show_cheque_details(){
            var payment_type = $("#payment_type").val();
            if(payment_type.toUpperCase()=='<?=strtoupper(cheque_name())?>'){
               $(".cheque_div").show();
            }
            else{
               $(".cheque_div").hide();
               $("#cheque_period,#cheque_number").val('');
            }
        }
        

       
        function set_previous_due(previous_due,tot_advance){
          $(".customer_previous_due").html(previous_due);
          $(".customer_tot_advance").html(tot_advance);
        }

        var base_url=$("#base_url").val();
        $("#store_id").on("change",function(){
          var store_id=$("#store_id").val();
          $.post(base_url+"sales/get_customers_select_list",{store_id:store_id},function(result){
              $("#customer_id").html('').append(result).select2();
              $("#sales_table > tbody").empty();
              calculate_tax();
          });
          $.post(base_url+"sales/get_tax_select_list",{store_id:store_id},function(result){
              $("#other_charges_tax_id").html('').append(result).select2();
              calculate_tax();
          });
        });

        /*Warehouse*/
        $("#warehouse_id").on("change",function(){
          var warehouse_id=$(this).val();
          $("#sales_table > tbody").empty();
          final_total();
        });
        /*Warehouse end*/

         $(".close_btn").on("click",function(){
           if(confirm('Are you sure you want to navigate away from this page?')){
               window.location='<?php echo $base_url; ?>dashboard';
             }
         });
         //Initialize Select2 Elements
             $(".select2").select2();
         //Date picker
             $('.datepicker').datepicker({
               autoclose: true,
            format: 'dd-mm-yyyy',
              todayHighlight: true
             });
          
        /*if($("#warehouse_id").val()==''){
          $("#item_search").attr({
            disabled: true,
          });
          toastr["warning"]("Please Select Warehouse!!");
          failed.currentTime = 0; 
          failed.play();
         
        }*/
         
         /* ---------- CALCULATE TAX -------------*/
        

         function calculate_tax(i){ //i=Row
            set_tax_value(i);

           //Find the Tax type and Tax amount
           var tax_type = $("#tr_tax_type_"+i).val();
           var tax_amount = $("#td_data_"+i+"_11").val();

           var qty=$("#td_data_"+i+"_3").val();
           var sales_price=parseFloat($("#td_data_"+i+"_10").val());
           $("#td_data_"+i+"_4").val(sales_price);
           /*Discounr*/
           var discount_amt=$("#td_data_"+i+"_8").val();
               discount_amt   =(isNaN(parseFloat(discount_amt)))    ? 0 : parseFloat(discount_amt);

           var amt=parseFloat(qty) * sales_price;//Taxable

           var total_amt=amt-discount_amt;
           total_amt = (tax_type=='Inclusive') ? total_amt : parseFloat(total_amt) + parseFloat(tax_amount);
           
           //Set Unit cost
           $("#td_data_"+i+"_9").val('').val(to_Fixed(total_amt));
        
           final_total();
         }
         
         // Calculate from total amount (reverse calculation)
         var calculating_total = {}; // Track which rows are being calculated to prevent loops
         function calculate_from_total(i){
           // Prevent recursion
           if(calculating_total[i]){
             return;
           }
           
           var total_amt_str = $("#td_data_"+i+"_9").val().replace(/[^0-9.-]/g, ''); // Get raw value without formatting
           var total_amt = parseFloat(total_amt_str) || 0;
           
           if(total_amt <= 0 || isNaN(total_amt) || total_amt_str === ''){
             return;
           }
           
           calculating_total[i] = true; // Set flag
           
           var qty = parseFloat($("#td_data_"+i+"_3").val()) || 0;
           if(qty <= 0 || isNaN(qty)){
             calculating_total[i] = false;
             return;
           }
           
           var tax_type = $("#tr_tax_type_"+i).val();
           var tax_amount = parseFloat($("#td_data_"+i+"_11").val()) || 0;
           var discount_amt = parseFloat($("#td_data_"+i+"_8").val()) || 0;
           
           // Reverse calculate: total_amt = (qty * sales_price - discount_amt) + tax_amount
           // So: qty * sales_price = total_amt - tax_amount + discount_amt
           var amt_before_tax = (tax_type=='Inclusive') ? total_amt : total_amt - tax_amount;
           var amt_before_discount = amt_before_tax + discount_amt;
           
           // Calculate sales price per unit
           var sales_price = amt_before_discount / qty;
           
           if(sales_price <= 0 || isNaN(sales_price)){
             calculating_total[i] = false;
             return;
           }
           
           // Temporarily disable calculation on price field
           $("#td_data_"+i+"_10").off('keyup');
           $("#td_data_"+i+"_9").off('keyup');
           
           // Update sales price field
           $("#td_data_"+i+"_10").val(to_Fixed(sales_price));
           $("#td_data_"+i+"_4").val(to_Fixed(sales_price));
           
           // Recalculate tax WITHOUT updating total (to preserve user input)
           set_tax_value(i);
           var tax_type_calc = $("#tr_tax_type_"+i).val();
           var tax_amount_calc = parseFloat($("#td_data_"+i+"_11").val()) || 0;
           var sales_price_calc = parseFloat($("#td_data_"+i+"_10").val()) || 0;
           var discount_amt_calc = parseFloat($("#td_data_"+i+"_8").val()) || 0;
           var amt_calc = qty * sales_price_calc;
           var total_amt_calc = amt_calc - discount_amt_calc;
           total_amt_calc = (tax_type_calc=='Inclusive') ? total_amt_calc : parseFloat(total_amt_calc) + parseFloat(tax_amount_calc);
           
           // DON'T update total field - keep user's input
           // $("#td_data_"+i+"_9").val(to_Fixed(total_amt_calc));
           
           final_total();
           
           // Re-enable after a delay
           setTimeout(function(){
             $("#td_data_"+i+"_10").on('keyup', function(){ calculate_tax(i); });
             $("#td_data_"+i+"_9").on('keyup', function(){ calculate_from_total(i); });
             calculating_total[i] = false;
           }, 200);
         }

        
         /* ---------- CALCULATE GST END -------------*/

         /*Calculate Coupon Discount Amount*/
         const discount_coupon_tot = function(subtotal) {
             var coupon_value=parseFloat($(".coupon_value").text());
                 coupon_value = isNaN(coupon_value) ? 0 : coupon_value;

             var coupon_type=$(".coupon_type").text();

             var discount_amt =0;
             if(coupon_type!='' && coupon_value>0){
                 if(coupon_type=='Percentage'){
                     discount_amt=(subtotal*coupon_value)/100;
                 }
                 else{//Fixed
                     discount_amt=coupon_value;
                 }
             }
             return discount_amt;
         }

         /* ---------- Final Description of amount ------------*/
         function final_total(){
           

           var rowcount=$("#hidden_rowcount").val();
           var subtotal=parseFloat(0);
           
           var other_charges_per_amt=parseFloat(0);
           var other_charges_total_amt=0;
           var taxable=0;
          if($("#other_charges_input").val()!=null && $("#other_charges_input").val()!=''){
             
              other_charges_tax_id =$('option:selected', '#other_charges_tax_id').attr('data-tax');
             other_charges_input=$("#other_charges_input").val();
             if(other_charges_tax_id>0){

               other_charges_per_amt=(other_charges_tax_id * other_charges_input)/100;
             }
             
             taxable=parseFloat(other_charges_per_amt)+parseFloat(other_charges_input);//Other charges input
             other_charges_total_amt=parseFloat(other_charges_per_amt)+parseFloat(other_charges_input);
           }
           else{
             //$("#other_charges_amt").html('0.00');
           }
           
         
           var tax_amt=0;
           var actual_taxable=0;
           var total_quantity=0;
         
           for(i=1;i<=rowcount;i++){
         
             if(document.getElementById("td_data_"+i+"_3")){
               //customer_id must exist
               if($("#td_data_"+i+"_3").val()!=null && $("#td_data_"+i+"_3").val()!=''){
                    actual_taxable=actual_taxable+ + +(parseFloat($("#td_data_"+i+"_13").val()) * parseFloat($("#td_data_"+i+"_3").val()));
                    subtotal=subtotal+ + +parseFloat($("#td_data_"+i+"_9").val());
                    if($("#td_data_"+i+"_7").val()>=0){
                      tax_amt=tax_amt+ + +$("#td_data_"+i+"_7").val();
                    }   
                    total_quantity +=parseFloat($("#td_data_"+i+"_3").val());
                }
                   
             }//if end
           }//for end
           
          
          //Show total Sales Quantitys
           $(".total_quantity").html(format_qty(total_quantity));

           //Apply Output on screen
           //subtotal
           if((subtotal!=null || subtotal!='') && (subtotal!=0)){
             
             //subtotal
             $("#subtotal_amt").html(to_Fixed(subtotal));
             
             //other charges total amount
             $("#other_charges_amt").html(to_Fixed(other_charges_total_amt));
             
             //other charges total amount
            

             taxable=taxable+subtotal;

             //Calculate Coupon Discount
             var coupon_amt = discount_coupon_tot(taxable);
               taxable-=coupon_amt;

             //discount_to_all_amt
            // if($("#discount_to_all_input").val()!=null && $("#discount_to_all_input").val()!=''){
                 var discount_input=parseFloat($("#discount_to_all_input").val());
                 discount_input = isNaN(discount_input) ? 0 : discount_input;
                 var discount=0;
                 if(discount_input>0){
                     var discount_type=$("#discount_to_all_type").val();
                     if(discount_type=='in_fixed'){
                       taxable-=discount_input;
                       discount=discount_input;
                       //Minus
                     }
                     else if(discount_type=='in_percentage'){
                         discount=(taxable*discount_input)/100;
                        taxable-=discount;
             
                     }
                 }
                 else{
                    //discount += $("#")
                 }
                   discount=parseFloat(discount);
                   
                    $("#coupon_discount_amt").html(to_Fixed(coupon_amt));  
                    $("#discount_to_all_amt").html(to_Fixed(discount));  
                    $("#hidden_discount_to_all_amt").val(to_Fixed(discount));  
             //}
             //subtotal_round=Math.round(taxable);
             subtotal_round=round_off(taxable);//round_off() method custom defined
             subtotal_diff=subtotal_round-taxable;
         
             $("#round_off_amt").html(to_Fixed(subtotal_diff)); 
             $("#total_amt").html(to_Fixed(subtotal_round)); 
             if(save_operation()){
               $("#amount").val(to_Fixed(subtotal_round));
             }
             $("#hidden_total_amt").val(to_Fixed(subtotal_round)); 
           }
           else{
             $("#subtotal_amt").html('0.00'); 
             $("#tax_amt").html('0.00'); 
             $("#round_off_amt").html('0.00'); 
             $("#total_amt").html('0.00'); 
             $("#hidden_total_amt").html('0.00'); 
             $("#discount_to_all_amt").html('0.00'); 
             $("#hidden_discount_to_all_amt").html('0.00'); 
             $("#subtotal_amt").html('0.00'); 
             $("#other_charges_amt").html('0.00');
               $("#amount").val('0.00');
           }
           
          // adjust_payments();
          //alert("final_total() end");
         }
         /* ---------- Final Description of amount end ------------*/
          
         function removerow(id){//id=Rowid
           
         $("#row_"+id).remove();
         final_total();
         failed.currentTime = 0;
        failed.play();
         }
               
     

    function enable_or_disable_item_discount(){
      /*var discount_input=parseFloat($("#discount_to_all_input").val());
      discount_input = isNaN(discount_input) ? 0 : discount_input;
      if(discount_input>0){
        $(".item_discount").attr({
          'readonly': true,
          'style': 'border-color:red;cursor:no-drop',
        });
      }
      else{
        $(".item_discount").attr({
          'readonly': false,
          'style': '',
        });
      }*/

      var rowcount=$("#hidden_rowcount").val();
      for(k=1;k<=rowcount;k++){
       if(document.getElementById("tr_item_id_"+k)){
         calculate_tax(k);
       }//if end
     }//for end

      //final_total();
    }

    

    //Sale Items Modal Operations Start
    function show_sales_item_modal(row_id){
      $('#sales_item').modal('toggle');
      $("#popup_tax_id").select2();

      //Find the item details
      var item_name = $("#td_data_"+row_id+"_1").html();
      var tax_type = $("#tr_tax_type_"+row_id).val();
      var tax_id = $("#tr_tax_id_"+row_id).val();
      var description = $("#description_"+row_id).val();

      /*Discount*/
      var item_discount_input = $("#item_discount_input_"+row_id).val();
      var item_discount_type = $("#item_discount_type_"+row_id).val();

      //Set to Popup
      $("#item_discount_input").val(item_discount_input);
      $("#item_discount_type").val(item_discount_type).select2();

      $("#popup_item_name").html(item_name);
      $("#popup_tax_type").val(tax_type).select2();
      $("#popup_tax_id").val(tax_id).select2();
      $("#popup_description").val(description);
      $("#popup_row_id").val(row_id);
    }

    function set_info(){
      var row_id = $("#popup_row_id").val();
      var tax_type = $("#popup_tax_type").val();
      var tax_id = $("#popup_tax_id").val();
      var description = $("#popup_description").val();
      var tax_name = ($('option:selected', "#popup_tax_id").attr('data-tax-value'));
      var tax = parseFloat($('option:selected', "#popup_tax_id").attr('data-tax'));

      /*Discounr*/
      var item_discount_input = $("#item_discount_input").val();
      var item_discount_type = $("#item_discount_type").val();

      //Set it into row 
      $("#item_discount_input_"+row_id).val(item_discount_input);
      $("#item_discount_type_"+row_id).val(item_discount_type);

      $("#tr_tax_type_"+row_id).val(tax_type);
      $("#tr_tax_id_"+row_id).val(tax_id);
      $("#tr_tax_value_"+row_id).val(tax);//%
      $("#description_"+row_id).val(description);
      $("#td_data_"+row_id+"_12").html(tax_name);
      
      calculate_tax(row_id);
      $('#sales_item').modal('toggle');
    }
    function set_tax_value(row_id){
      //get the sales price of the item
      var tax_type = $("#tr_tax_type_"+row_id).val();
      var tax = $("#tr_tax_value_"+row_id).val(); //%
      var qty=$("#td_data_"+row_id+"_3").val();
          qty = (isNaN(qty)) ? 0 :qty;
      var sales_price = parseFloat($("#td_data_"+row_id+"_10").val());
          sales_price = (isNaN(sales_price)) ? 0 :sales_price;
          sales_price = sales_price * qty;

      /*Discount*/
      var item_discount_type = $("#item_discount_type_"+row_id).val();
      var item_discount_input = parseFloat($("#item_discount_input_"+row_id).val());
          item_discount_input = (isNaN(item_discount_input)) ? 0 :item_discount_input;

      //Calculate discount      
      var discount_amt=(item_discount_type=='Percentage') ? ((sales_price) * item_discount_input)/100 : (item_discount_input*qty);
      sales_price-=parseFloat(discount_amt);

      var tax_amount = (tax_type=='Inclusive') ? calculate_inclusive(sales_price,tax) : calculate_exclusive(sales_price,tax);
      
      $("#td_data_"+row_id+"_8").val(to_Fixed(discount_amt));

      $("#td_data_"+row_id+"_11").val(to_Fixed(tax_amount));
    }
    //Sale Items Modal Operations End
      </script>


      <!-- UPDATE OPERATIONS -->
      <script type="text/javascript">
         <?php if(isset($sales_id) || isset($quotation_id)|| isset($order_id)){ ?> 
             $(document).ready(function(){
                var base_url='<?= base_url();?>';
                var path='';
                var id='';
                <?php if(isset($sales_id) && !empty($sales_id)) {?>
                  var id='<?=$sales_id;?>';  
                  var path = 'return_sales_list';
                <?php }?>

                <?php if(isset($quotation_id) && !empty($quotation_id)) {?>
                  var id='<?=$quotation_id;?>';  
                  var path = 'return_quotation_list';
                <?php }?>
   
                $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
                $.post(base_url+"sales/"+path+"/"+id,{},function(result){
                //  alert(result);
                  $('#sales_table tbody').append(result);
                  $("#hidden_rowcount").val(parseInt(<?=$items_count;?>)+1);
                  success.currentTime = 0;
                  success.play();
                  get_coupon_details();  
                  enable_or_disable_item_discount();
                  $(".overlay").remove();
              }); 
             });
         <?php }?>
      </script>
      <script>
        $(function () {
          //bootstrap WYSIHTML5 - text editor
          //$("#invoice_terms").wysihtml5()
        })
        
        // Track last checked customer to prevent duplicate calls
        var last_checked_customer_id_sales = null;
        var currency_check_timeout_sales = null;

        // Customer currency switching logic (copied from POS)
        function check_customer_currency_for_sales() {
            var customer_id = $("#customer_id").val();
            var base_url = $("#base_url").val();

            // Hide both currency displays and customer type first
            $("#customer_currency_info").hide();
            $("#walkin_currency_info").hide();
            $("#customer_type_info").hide();

            // Skip if same customer was already checked
            if (customer_id === last_checked_customer_id_sales) {
                return;
            }

            // Clear any existing timeout
            if (currency_check_timeout_sales) {
                clearTimeout(currency_check_timeout_sales);
            }

            // Update last checked customer
            last_checked_customer_id_sales = customer_id;


            if (!customer_id || customer_id === '') {
                // Reset walk-in customer flag since no customer is selected
                window.walkinCustomerSelected = false;
                
                // Hide both currency displays and customer type
                $("#customer_currency_info").hide();
                $("#walkin_currency_info").hide();
                $("#customer_type_info").hide();
                
                // Reset to base currency symbols if nothing selected
                var baseSymbol = window.baseCurrencySymbol || '$';
                setAllCurrencySymbols(baseSymbol);
                return;
            }

            // Check if it's a walk-in customer (ID 1 or contains "walk-in" in text)
            var customerText = $("#customer_id option:selected").text();
            if (customer_id === '1' || customerText.toLowerCase().includes('walk-in')) {
                // Hide customer currency info first
                $("#customer_currency_info").hide();
                
                // Get base currency info from the page data
                var baseCurrency = window.baseCurrencyName || 'Base Currency';
                var baseCode = window.baseCurrencyCode || 'USD';
                var baseSymbol = window.baseCurrencySymbol || '$';
                
                $("#walkin_currency_name").text(baseCurrency + " (" + baseCode + ")");
                $("#walkin_currency_info").show();
                
                // Update currency symbols
                setAllCurrencySymbols(baseSymbol);
                
                // Ensure walk-in currency stays visible by setting a flag
                window.walkinCustomerSelected = true;
                
                return;
            }

            if (customer_id && customer_id !== '' && customer_id !== '1') {
                // Reset walk-in customer flag since this is a regular customer
                window.walkinCustomerSelected = false;
                
                // Hide walk-in currency info
                $("#walkin_currency_info").hide();
                
                // Make AJAX call to get customer type
                $.ajax({
                    url: base_url + 'customers/get_customer_type',
                    type: 'POST',
                    data: { customer_id: customer_id },
                    dataType: 'json',
                    success: function(type_response) {
                        if (type_response.status) {
                            // Show customer type info
                            var customer_type_text = type_response.customer_type.charAt(0).toUpperCase() + type_response.customer_type.slice(1);
                            $("#customer_type_text").text(customer_type_text);
                            $("#customer_type_info").show();
                            
                            // Store customer type for price selection
                            window.currentCustomerType = type_response.customer_type;
                            window.currentPriceType = type_response.default_price_type;
                        }
                    }
                });
                
                // Make AJAX call to check customer currency
                $.ajax({
                    url: base_url + 'customers/get_customer_currency',
                    type: 'POST',
                    data: { customer_id: customer_id },
                    dataType: 'json',
                    success: function(currency_response) {
                        if (currency_response.status) {
                            // Show customer currency info
                            var customer_currency_text = '';
                            if (currency_response.customer_currency_name && currency_response.customer_currency_code) {
                                customer_currency_text = currency_response.customer_currency_name + ' (' + currency_response.customer_currency_code + ')';
                } else {
                                customer_currency_text = currency_response.currency_name + ' (' + currency_response.currency_code + ')';
                            }
                            
                            $("#customer_currency_name").text(customer_currency_text);
                            $("#customer_currency_info").show();
                            
                            // Check exchange rate IMMEDIATELY if customer has different currency
                            if (currency_response.customer_currency_id && 
                                currency_response.base_currency_id && 
                                currency_response.customer_currency_id != currency_response.base_currency_id) {
                                // Pass customer currency as FROM and base currency as TO with names and codes
                                checkExchangeRate(
                                    currency_response.customer_currency_id, 
                                    currency_response.base_currency_id,
                                    currency_response.customer_currency_name,
                                    currency_response.customer_currency_code,
                                    currency_response.base_currency_name,
                                    currency_response.base_currency_code
                                );
                            }
                            
                            // Update currency symbols
                            if (currency_response.currency_symbol) {
                                setAllCurrencySymbols(currency_response.currency_symbol);
                            }
                        }
            },
            error: function(xhr, status, error) {
                        // Silent error handling
                    }
                });
            } else {
                // Walk-in customer selected - hide currency info
                $("#customer_currency_info").hide();
            }
        }

        // Helper function to set all currency symbols at once
        function setAllCurrencySymbols(symbol) {
            $(".currency_symbol").text(symbol);
        }


        // Global flag to track exchange rate validation
        var exchangeRateValid = true;
        var exchangeRateCheckInProgress = false;

        // Function to check exchange rate between currencies
        function checkExchangeRate(from_currency_id, to_currency_id, from_currency_name, from_currency_code, to_currency_name, to_currency_code) {
            if (!from_currency_id || !to_currency_id || from_currency_id == to_currency_id) {
                exchangeRateValid = true;
                return; // No need to check if same currency or missing data
            }

            // Store current currency IDs and details for modal - ALWAYS store them
            window.currentFromCurrencyId = from_currency_id;
            window.currentToCurrencyId = to_currency_id;
            window.currentFromCurrencyName = from_currency_name || 'Customer Currency';
            window.currentFromCurrencyCode = from_currency_code || 'CUR';
            window.currentToCurrencyName = to_currency_name || 'System Currency';
            window.currentToCurrencyCode = to_currency_code || 'SYS';

            var base_url = $("#base_url").val();
            exchangeRateCheckInProgress = true;
            
            $.ajax({
                url: base_url + 'exchange_rates/check_exchange_rate',
                type: 'POST',
                data: { 
                    from_currency_id: from_currency_id,
                    to_currency_id: to_currency_id
                },
                dataType: 'json',
                success: function(response) {
                    exchangeRateCheckInProgress = false;
                    
                    if (!response || !response.exists) {
                        exchangeRateValid = false;
                        // Only show alert if rate is actually missing
                        showEnterpriseAlert(
                            'Rate missing, please add exchange rate for this currency conversion.',
                            'warning'
                        );
                    } else {
                        exchangeRateValid = true;
                        // Rate exists, no alert needed
                    }
                },
                error: function(xhr, status, error) {
                    exchangeRateCheckInProgress = false;
                    exchangeRateValid = false;
                    // Don't show alert on error - let the success handler handle it
                }
            });
        }

        // Enterprise Alert System
        function showEnterpriseAlert(message, type) {
            // Remove any existing alerts
            $('.enterprise-alert').remove();
            
            var alertClass = 'warning';
            if (type === 'success') alertClass = 'success';
            if (type === 'error') alertClass = 'error';
            
            var alertHtml = '<div class="enterprise-alert ' + alertClass + '">' +
                '<i class="fa fa-exclamation-triangle"></i> ' + message +
                '<br><br>' +
                '<a href="' + $("#base_url").val() + 'exchange_rates" class="btn btn-sm btn-warning" style="margin-top: 8px;">' +
                '<i class="fa fa-plus"></i> Add Exchange Rate</a>' +
                '</div>';
            
            $('body').append(alertHtml);
            
            // Auto remove after 8 seconds (longer to allow user to click button)
            setTimeout(function() {
                $('.enterprise-alert').fadeOut(300, function() {
                    $(this).remove();
                });
            }, 8000);
        }



        // Function to load currencies into dropdowns
        function loadCurrencies() {
            var baseUrl = $("#base_url").val();
            
            // Always load currencies fresh to ensure we have the latest data
            $.ajax({
                url: baseUrl + 'currencies/get_all_currencies',
                type: 'POST',
                dataType: 'json',
                success: function(response) {
                    if (response && response.currencies) {
                        window.availableCurrencies = response.currencies;
                        populateCurrencyDropdowns(response.currencies);
                    } else {
                        // Fallback - create currencies from known data
                        var currencies = [
                            {
                                id: window.currentFromCurrencyId,
                                currency_name: 'Customer Currency',
                                currency_code: 'CUR'
                            },
                            {
                                id: window.currentToCurrencyId,
                                currency_name: 'System Currency', 
                                currency_code: 'SYS'
                            }
                        ];
                        populateCurrencyDropdowns(currencies);
                    }
                },
                error: function(xhr, status, error) {
                    // Fallback - create currencies from known data
                    var currencies = [
                        {
                            id: window.currentFromCurrencyId,
                            currency_name: 'Customer Currency',
                            currency_code: 'CUR'
                        },
                        {
                            id: window.currentToCurrencyId,
                            currency_name: 'System Currency',
                            currency_code: 'SYS'
                        }
                    ];
                    populateCurrencyDropdowns(currencies);
                }
            });
        }

        // Helper function to populate currency dropdowns
        function populateCurrencyDropdowns(currencies) {
            var fromSelect = $('#from_currency');
            var toSelect = $('#to_currency');
            
            
            fromSelect.empty().append('<option value="">Select Customer Currency</option>');
            toSelect.empty().append('<option value="">Select System Currency</option>');
            
            $.each(currencies, function(index, currency) {
                var option = '<option value="' + currency.id + '">' + 
                           currency.currency_name + ' (' + currency.currency_code + ')</option>';
                fromSelect.append(option);
                toSelect.append(option);
            });
            
            // Set the currencies based on stored IDs with retry mechanism
            if (window.currentFromCurrencyId) {
                fromSelect.val(window.currentFromCurrencyId);
                
                // If selection failed, try again after a short delay
                if (!fromSelect.val()) {
                    setTimeout(function() {
                        fromSelect.val(window.currentFromCurrencyId);
                    }, 100);
                }
            }
            
            if (window.currentToCurrencyId) {
                toSelect.val(window.currentToCurrencyId);
                
                // If selection failed, try again after a short delay
                if (!toSelect.val()) {
                    setTimeout(function() {
                        toSelect.val(window.currentToCurrencyId);
                    }, 100);
                }
            }
        }

        // Function to check payment currency exchange rate
        function checkPaymentCurrencyExchangeRate() {
            var payment_currency_id = $("#payment_currency").val();
            var base_currency_id = '<?= get_base_currency()->id ?>';
            
            if (payment_currency_id && payment_currency_id != base_currency_id) {
                checkExchangeRate(base_currency_id, payment_currency_id);
            }
        }


        // Validate account currency matches payment currency
        function validateAccountCurrency() {
            var selectedAccount = $('#account_id').val();
            var selectedPaymentCurrency = $('#payment_currency').val();
            
            if (!selectedAccount || !selectedPaymentCurrency) {
                $('#account_currency_alert').hide();
                return true; // Allow if no selection made yet
            }
            
            // Hide alert if account is cleared
            if (selectedAccount === '') {
                $('#account_currency_alert').hide();
                return true;
            }
            
            // Get account currency information
            $.ajax({
                url: '<?= base_url(); ?>sales/get_account_currency',
                type: 'POST',
                data: { account_id: selectedAccount },
                dataType: 'json',
                success: function(response) {
                    if (response.success && response.currency_id) {
                        if (response.currency_id != selectedPaymentCurrency) {
                            $('#account_currency_alert').show();
                            $('#account_currency_alert').html('<i class="fa fa-exclamation-triangle"></i> <strong>Error:</strong> Selected account currency (' + response.currency_code + ') doesn\'t match payment currency. Please select a matching currency account or change the payment currency.');
                            // Clear the account selection to force user to select correct one
                            $('#account_id').val('').trigger('change');
                            return false;
                        } else {
                            $('#account_currency_alert').hide();
                            return true;
                        }
                    } else {
                        $('#account_currency_alert').hide();
                        return true;
                    }
                },
                error: function() {
                    $('#account_currency_alert').hide();
                    return true;
                }
            });
        }
        
        // Auto-select correct currency account when payment currency changes
        function autoSelectCurrencyAccount() {
            var selectedPaymentCurrency = $('#payment_currency').val();
            
            if (!selectedPaymentCurrency) {
                // Clear account dropdown if no currency selected
                $('#account_id').empty().append('<option value="">-None-</option>');
                return;
            }
            
            // Get customer currency first to prioritize customer's currency account
            var customer_id = $("#customer_id").val();
            var customerCurrencyId = null;
            
            if (customer_id) {
                $.ajax({
                    url: '<?= base_url(); ?>sales/get_customer_currency',
                    type: 'POST',
                    data: { customer_id: customer_id },
                    dataType: 'json',
                    async: false,
                    success: function(res) {
                        if (res && res.status && res.customer_currency_id) {
                            customerCurrencyId = res.customer_currency_id;
                        }
                    }
                });
            }
            
            // Get accounts for the selected currency
            $.ajax({
                url: '<?= base_url(); ?>sales/get_accounts_by_currency',
                type: 'POST',
                data: { currency_id: selectedPaymentCurrency },
                dataType: 'json',
                success: function(response) {
                    // Clear existing options
                    $('#account_id').empty();
                    
                    if (response.success && response.accounts && response.accounts.length > 0) {
                        // Add default option
                        $('#account_id').append('<option value="">-None-</option>');
                        
                        // Add accounts for this currency
                        for (var i = 0; i < response.accounts.length; i++) {
                            var account = response.accounts[i];
                            var option = '<option value="' + account.id + '">' + account.account_name + ' (' + account.currency_code + ')</option>';
                            $('#account_id').append(option);
                        }
                        
                        // Smart account selection logic
                        var selectedAccount = null;
                        
                        // 1. If payment currency matches customer currency, prioritize customer's currency account
                        if (customerCurrencyId && selectedPaymentCurrency == customerCurrencyId) {
                            
                            // Look for cash account in customer's currency first
                            for (var i = 0; i < response.accounts.length; i++) {
                                var account = response.accounts[i];
                                if (account.account_name.toLowerCase().includes('cash')) {
                                    selectedAccount = account;
                                    break;
                                }
                            }
                            
                            // If no cash account, use first account in customer's currency
                            if (!selectedAccount) {
                                selectedAccount = response.accounts[0];
                            }
                        } else {
                            // 2. If payment currency doesn't match customer currency, use normal logic
                            
                            // Look for cash account first
                            for (var i = 0; i < response.accounts.length; i++) {
                                var account = response.accounts[i];
                                if (account.account_name.toLowerCase().includes('cash')) {
                                    selectedAccount = account;
                                    break;
                                }
                            }
                            
                            // If no cash account found, use the first account
                            if (!selectedAccount) {
                                selectedAccount = response.accounts[0];
                            }
                        }
                        
                        if (selectedAccount) {
                            // Small delay to ensure DOM is updated
                            setTimeout(function() {
                                $('#account_id').val(selectedAccount.id).trigger('change');
                                // Refresh Select2 dropdown to show the selected value
                                $('#account_id').select2('destroy').select2();
                                // Also update the account currency alert
                                $('#account_currency_alert').hide();
                            }, 100);
                        }
                    } else if (response.error) {
                        $('#account_id').append('<option value="">Error: ' + response.error + '</option>');
                    } else {
                        // Show message if no accounts found
                        $('#account_id').append('<option value="">No accounts available for this currency</option>');
                    }
                },
                error: function(xhr, status, error) {
                    $('#account_id').empty().append('<option value="">Error loading accounts</option>');
                }
            });
        }

        // Initialize account dropdown based on default currency
        function initializeAccountDropdown() {
            // Small delay to ensure all elements are loaded
            setTimeout(function() {
                var defaultCurrency = $('#payment_currency').val();
                if (defaultCurrency) {
                    autoSelectCurrencyAccount();
                }
            }, 200);
        }
        
        // Function to load accounts when customer currency is set
        function loadAccountsForCustomerCurrency() {
            var customer_id = $("#customer_id").val();
            var paymentCurrency = $('#payment_currency').val();
            
            if (customer_id && paymentCurrency) {
                autoSelectCurrencyAccount();
            }
        }
        
        // Make the function globally available
        window.loadAccountsForCustomerCurrency = loadAccountsForCustomerCurrency;
        
        // Convert grand total to customer currency for display
        function convertGrandTotalToCustomerCurrency(customer_currency_id, base_currency_id) {
            var base_url = $("#base_url").val();
            
            $.ajax({
                url: base_url + 'sales/get_exchange_rate_for_payment',
                type: 'POST',
                data: {
                    from_currency: base_currency_id,
                    to_currency: customer_currency_id
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        // Get current grand total (in base currency)
                        var grand_total = parseFloat($('#total_amt').text().replace(/,/g, ''));
                        if (isNaN(grand_total)) grand_total = 0;
                        
                        // Convert to customer currency
                        var converted_total = grand_total * response.exchange_rate;
                        
                        // Update display
                        $('#total_amt').text(converted_total.toFixed(2));
                        
                        // Amount field will be updated by payment currency change event
                    }
                }
            });
        }

        // Customer change event - trigger exchange rate check immediately
        $("#customer_id").on("change select2:select", function () {
            check_customer_currency_for_sales();
        });

        // Set base currency data for JavaScript
        window.baseCurrencyName = '<?= get_base_currency()->currency_name ?>';
        window.baseCurrencyCode = '<?= get_base_currency()->currency_code ?>';
        window.baseCurrencySymbol = '<?= get_base_currency()->symbol ?>';
        window.baseCurrencyId = '<?= get_base_currency()->id ?>';

        // Run on page load - check currency and exchange rate immediately
        $(document).ready(function () {
            // Small delay to ensure all elements are loaded
            setTimeout(function() {
                check_customer_currency_for_sales();
            }, 500);
            
            // Exchange rate modal save handler
            $('#saveExchangeRate').on('click', function() {
                saveExchangeRate();
            });
            
            // Exchange rate modal form validation
            $('#exchangeRateForm').on('submit', function(e) {
                e.preventDefault();
                saveExchangeRate();
            });
            
        });


        // Function to save exchange rate
        function saveExchangeRate() {
            var rateSource = $('input[name="rate_source"]:checked').val();
            var formData = {
                from_currency_id: $('#from_currency').val() || window.currentFromCurrencyId,
                to_currency_id: $('#to_currency').val() || window.currentToCurrencyId,
                exchange_rate: $('#exchange_rate').val(),
                rate_date: $('#rate_date').val(),
                rate_note: $('#rate_note').val(),
                rate_source: rateSource
            };
            
            // Validate form
            if (!formData.from_currency_id || !formData.to_currency_id) {
                alert('Please select both currencies.');
                return;
            }
            
            if (formData.from_currency_id == formData.to_currency_id) {
                alert('From and To currencies cannot be the same.');
                return;
            }
            
            if (rateSource === 'manual' && !formData.exchange_rate) {
                alert('Please enter the exchange rate.');
                return;
            }
            
            var baseUrl = $("#base_url").val();
            
            // Show loading state
            $('#saveExchangeRate').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
            
            // If API source, fetch rate first
            if (rateSource === 'api') {
                fetchExchangeRateFromAPI(formData, baseUrl);
            } else {
                // Manual entry - save directly
                saveExchangeRateData(formData, baseUrl);
            }
        }

        // Function to fetch exchange rate from API
        function fetchExchangeRateFromAPI(formData, baseUrl) {
            $.ajax({
                url: baseUrl + 'exchange_rates/fetch_from_api',
                type: 'POST',
                data: {
                    from_currency_id: formData.from_currency_id,
                    to_currency_id: formData.to_currency_id,
                    rate_date: formData.rate_date
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success && response.exchange_rate) {
                        formData.exchange_rate = response.exchange_rate;
                        formData.rate_note = (formData.rate_note || '') + ' (Fetched from API)';
                        saveExchangeRateData(formData, baseUrl);
                    } else {
                        // Switch to manual entry mode automatically
                        $('input[name="rate_source"][value="manual"]').prop('checked', true);
                        $('#exchange_rate').focus();
                        showEnterpriseAlert('API rate fetch failed: ' + (response.message || 'Unknown error') + '. Switched to manual entry mode.', 'warning');
                        $('#saveExchangeRate').prop('disabled', false).html('<i class="fa fa-save"></i> Save Exchange Rate');
                    }
                },
                error: function() {
                    // Switch to manual entry mode automatically
                    $('input[name="rate_source"][value="manual"]').prop('checked', true);
                    $('#exchange_rate').focus();
                    showEnterpriseAlert('API rate fetch failed. Switched to manual entry mode. Please enter the exchange rate manually.', 'warning');
                    $('#saveExchangeRate').prop('disabled', false).html('<i class="fa fa-save"></i> Save Exchange Rate');
                }
            });
        }

        // Function to save exchange rate data
        function saveExchangeRateData(formData, baseUrl) {
            $.ajax({
                url: baseUrl + 'exchange_rates/save_exchange_rate',
                type: 'POST',
                data: formData,
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        // Close modal
                        $('#exchangeRateModal').modal('hide');
                        
                        // Show success message
                        showEnterpriseAlert('Exchange rate saved successfully!', 'success');
                        
                        // Re-check exchange rate
                        if (window.currentFromCurrencyId && window.currentToCurrencyId) {
                            checkExchangeRate(
                                window.currentFromCurrencyId, 
                                window.currentToCurrencyId,
                                window.currentFromCurrencyName,
                                window.currentFromCurrencyCode,
                                window.currentToCurrencyName,
                                window.currentToCurrencyCode
                            );
                        }
                        
                        // Reset form
                        $('#exchangeRateForm')[0].reset();
                        $('input[name="rate_source"][value="manual"]').prop('checked', true);
                    } else {
                        alert('Error saving exchange rate: ' + (response.message || 'Unknown error'));
                    }
                },
                error: function(xhr, status, error) {
                    alert('Error saving exchange rate. Please try again.');
                },
                complete: function() {
                    // Reset button state
                    $('#saveExchangeRate').prop('disabled', false).html('<i class="fa fa-save"></i> Save Exchange Rate');
                }
            });
        }

        function update_payment_currency_sales() {
            var selected_currency = $('#payment_currency').val();
            var base_currency_id = '<?= get_base_currency()->id; ?>';
            var customer_currency_id = null;
            
            // Get customer currency ID if available
            var customer_id = $("#customer_id").val();
            if (customer_id) {
                $.ajax({
                    url: '<?= base_url(); ?>sales/get_customer_currency',
                    type: 'POST',
                    data: { customer_id: customer_id },
                    dataType: 'json',
                    async: false,
                    success: function(res) {
                        if (res && res.status && res.customer_currency_id) {
                            customer_currency_id = res.customer_currency_id;
                        }
                    }
                });
            }
            
            // Get the current grand total (this is displayed in customer currency if customer has different currency)
            var grand_total = parseFloat($('#total_amt').text().replace(/,/g, ''));
            if (isNaN(grand_total)) grand_total = 0;
            
            if (grand_total > 0) {
                if (selected_currency == base_currency_id) {
                    // Paying in base currency - convert from customer currency to base currency
                    if (customer_currency_id && customer_currency_id != base_currency_id) {
                        $.ajax({
                            url: '<?= base_url(); ?>sales/get_exchange_rate_for_payment',
                            type: 'POST',
                            data: {
                                from_currency: customer_currency_id,
                                to_currency: base_currency_id
                            },
                            dataType: 'json',
                            success: function(response) {
                                if (response.success) {
                                    // Convert from customer currency to base currency
                                    var converted_amount = grand_total * response.exchange_rate;
                                    
                                    $('#amount').val(converted_amount.toFixed(2));
                                }
                            }
                        });
                    } else {
                        // Same as base currency - grand total is already in base currency
                        $('#amount').val(grand_total.toFixed(2));
                    }
                } else if (selected_currency == customer_currency_id) {
                    // Paying in customer currency - use grand total as is (it's already displayed in customer currency)
                    $('#amount').val(grand_total.toFixed(2));
                } else {
                    // Fallback - use grand total as is
                    $('#amount').val(grand_total.toFixed(2));
                }
            }
        }
      </script>
      <!-- UPDATE OPERATIONS end-->

      <!-- Make sidebar menu hughlighter/selector -->
      <script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>

      <!-- Removed keyboard shortcuts script -->

      <script>
        // Simple batch validation for Sales form - only validate, don't break existing functionality
        $(document).ready(function() {
            // Add batch validation to existing form submission
            $('#sales-form').on('submit', function(e) {
                if (!validateBatchSelection()) {
                    e.preventDefault();
                    return false;
                }
                // Let the form submit normally if validation passes
            });
        });
        
        function validateBatchSelection() {
            var hasError = false;
            var errorMessage = '';
            var batchTrackedItems = [];
            
            // Check each item row for batch tracking
            $('input[name^="item_id_"]').each(function() {
                var rowId = $(this).attr('name').replace('item_id_', '');
                var itemId = $(this).val();
                var batchNumber = $('#batch_number_' + rowId).val();
                
                if (itemId && batchNumber !== undefined) {
                    // Check if this item has batch tracking enabled
                    var batchTrackingEnabled = $('#tr_item_id_' + rowId).data('batch-tracking-enabled');
                    
                    if (batchTrackingEnabled == 1) {
                        batchTrackedItems.push({
                            name: $('#td_data_' + rowId + '_0').text().trim(),
                            rowId: rowId,
                            hasBatch: batchNumber && batchNumber.trim() !== ''
                        });
                        
                        if (!batchNumber || batchNumber.trim() === '') {
                            var itemName = $('#td_data_' + rowId + '_0').text().trim();
                            errorMessage += '• ' + itemName + ' has batch tracking enabled but no batch is selected\\n';
                            hasError = true;
                        }
                    }
                }
            });
            
            if (hasError) {
                var fullMessage = 'BATCH REQUIRED - CANNOT PROCEED:\\n\\n' + errorMessage + '\\n\\nThese products have batch tracking enabled. You must select batches before saving.';
                showNotification('error', fullMessage);
                return false;
            }
            
            return true;
        }
      </script>
</body>
